/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.api.format;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.olingo.commons.api.format.TypeUtil;

public final class ContentType {
    public static final ContentType APPLICATION_XML = ContentType.create("application/xml");
    public static final ContentType APPLICATION_ATOM_XML = ContentType.create("application/atom+xml");
    public static final ContentType APPLICATION_ATOM_XML_ENTRY = ContentType.create(APPLICATION_ATOM_XML, "type=entry");
    public static final ContentType APPLICATION_ATOM_XML_FEED = ContentType.create(APPLICATION_ATOM_XML, "type=feed");
    public static final ContentType APPLICATION_ATOM_SVC = ContentType.create("application/atomsvc+xml");
    public static final ContentType APPLICATION_JSON = ContentType.create("application/json");
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.create("application/octet-stream");
    public static final ContentType TEXT_PLAIN = ContentType.create("text/plain");
    public static final ContentType MULTIPART_MIXED = ContentType.create("multipart/mixed");
    public static final ContentType APPLICATION_XHTML_XML = ContentType.create("application/xhtml+xml");
    public static final ContentType APPLICATION_SVG_XML = ContentType.create("application/svg+xml");
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.create("application/x-www-form-urlencoded");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.create("multipart/form-data");
    public static final ContentType TEXT_XML = ContentType.create("text/xml");
    public static final ContentType TEXT_HTML = ContentType.create("text/html");
    public static final String PARAMETER_CHARSET_UTF8 = "charset=utf-8";
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;

    private ContentType(String type, String subtype, Map<String, String> parameters) {
        this.type = this.validateType(type);
        this.subtype = this.validateType(subtype);
        if (parameters == null) {
            this.parameters = Collections.emptyMap();
        } else {
            this.parameters = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            this.parameters.putAll(parameters);
        }
    }

    private String validateType(String type) {
        if (type == null || type.isEmpty() || "*".equals(type)) {
            throw new IllegalArgumentException("Illegal type '" + type + "'.");
        }
        if (type.indexOf(32) >= 0) {
            throw new IllegalArgumentException("Illegal whitespace found for type '" + type + "'.");
        }
        return type;
    }

    public static boolean isParseable(String format) {
        try {
            return ContentType.create(format) != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static ContentType create(String format, String ... parameters) {
        ContentType ct = ContentType.parse(format);
        for (String p : parameters) {
            String[] keyvalue = TypeUtil.parseParameter(p);
            ct.parameters.put(keyvalue[0], keyvalue[1]);
        }
        return ct;
    }

    public static ContentType create(ContentType contentType, String ... parameters) {
        ContentType ct = new ContentType(contentType.type, contentType.subtype, contentType.parameters);
        for (String p : parameters) {
            String[] keyvalue = TypeUtil.parseParameter(p);
            ct.parameters.put(keyvalue[0], keyvalue[1]);
        }
        return ct;
    }

    public static ContentType create(String format) {
        if (format == null) {
            throw new IllegalArgumentException("Parameter format MUST NOT be NULL.");
        }
        ArrayList<String> typeSubtype = new ArrayList<String>();
        HashMap<String, String> parameters = new HashMap<String, String>();
        ContentType.parse(format, typeSubtype, parameters);
        return new ContentType((String)typeSubtype.get(0), (String)typeSubtype.get(1), parameters);
    }

    public static ContentType parse(String format) {
        try {
            return ContentType.create(format);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parse(String format, List<String> typeSubtype, Map<String, String> parameters) {
        String params;
        String[] typesAndParameters = format.split(";", 2);
        String types = typesAndParameters[0];
        String string = params = typesAndParameters.length > 1 ? typesAndParameters[1] : null;
        if (!types.contains("/")) throw new IllegalArgumentException("No separator '/' was found in format '" + format + "'.");
        String[] tokens = types.split("/");
        if (tokens.length != 2) throw new IllegalArgumentException("Too many '/' in format '" + format + "'.");
        if (tokens[0] == null || tokens[0].isEmpty()) {
            throw new IllegalArgumentException("No type found in format '" + format + "'.");
        }
        if (tokens[1] == null || tokens[1].isEmpty()) {
            throw new IllegalArgumentException("No subtype found in format '" + format + "'.");
        }
        typeSubtype.add(tokens[0]);
        typeSubtype.add(tokens[1]);
        TypeUtil.parseParameters(params, parameters);
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object obj) {
        Boolean compatible = this.isEqualWithoutParameters(obj);
        if (compatible == null) {
            ContentType other = (ContentType)obj;
            if (this.parameters == null) {
                if (other.parameters != null) {
                    return false;
                }
            } else if (this.parameters.size() == other.parameters.size()) {
                Iterator<Map.Entry<String, String>> entries = this.parameters.entrySet().iterator();
                Iterator<Map.Entry<String, String>> otherEntries = other.parameters.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<String, String> e = entries.next();
                    Map.Entry<String, String> oe = otherEntries.next();
                    if (!ContentType.areEqual(e.getKey(), oe.getKey())) {
                        return false;
                    }
                    if (ContentType.areEqual(e.getValue(), oe.getValue())) continue;
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }
        return compatible;
    }

    public boolean isCompatible(ContentType obj) {
        Boolean compatible = this.isEqualWithoutParameters(obj);
        return compatible == null || compatible != false;
    }

    private Boolean isEqualWithoutParameters(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentType other = (ContentType)obj;
        if (this.subtype == null ? other.subtype != null : !this.subtype.equalsIgnoreCase(other.subtype)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equalsIgnoreCase(other.type)) {
            return false;
        }
        return null;
    }

    private static boolean areEqual(String first, String second) {
        return first == null && second == null || first.equalsIgnoreCase(second);
    }

    public String toContentTypeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type).append("/").append(this.subtype);
        for (String key : this.parameters.keySet()) {
            sb.append(";").append(key).append("=").append(this.parameters.get(key));
        }
        return sb.toString();
    }

    public String toString() {
        return this.toContentTypeString();
    }
}

