/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.conf;

import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.UserException;

public class Specification {
    private String _name = "";
    private int _major = 1;
    private String _minor = "0";
    private String _description = "";
    private Compatibility _compatibility;
    private static Localizer _loc = Localizer.forPackage(Specification.class);

    public Specification(String fullName) {
        try {
            Object[] tokens = this.parse(fullName);
            this._name = tokens[0].toString();
            this._major = tokens.length > 1 ? Integer.parseInt(tokens[1].toString()) : 1;
            this._minor = tokens.length > 2 ? tokens[2].toString() : "0";
        }
        catch (Exception e) {
            throw new UserException(_loc.get("spec-wrong-format", (Object)fullName));
        }
    }

    public String getName() {
        return this._name;
    }

    public int getVersion() {
        return this._major;
    }

    public String getMinorVersion() {
        return this._minor;
    }

    public String getDescription() {
        return this._description;
    }

    public Specification setDescription(String description) {
        this._description = description;
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().isInstance(other)) {
            return false;
        }
        Specification that = (Specification)other;
        return StringUtils.equals((String)this._name, (String)this._name) && this._major == that._major && StringUtils.equals((String)this._minor, (String)this._minor);
    }

    public boolean isSame(Specification other) {
        return this == other || other != null && this._name.equalsIgnoreCase(other._name);
    }

    public boolean isSame(String other) {
        return this._name.equalsIgnoreCase(other);
    }

    public int compareVersion(Specification other) {
        return this._major > other._major ? 1 : (this._major == other._major ? 0 : -1);
    }

    public String toString() {
        return this._name.toUpperCase() + " " + this._major + "." + this._minor;
    }

    private Object[] parse(String str) {
        int space = str.indexOf(32);
        if (space == -1) {
            return new Object[]{str};
        }
        String name = str.substring(0, space);
        String version = str.substring(space + 1);
        int dot = version.indexOf(46);
        if (dot == -1) {
            return new Object[]{name, version};
        }
        return new Object[]{name, version.substring(0, dot), version.substring(dot + 1)};
    }

    public void setCompatibility(Compatibility compatibility) {
        this._compatibility = compatibility;
    }

    public Compatibility getCompatibility() {
        return this._compatibility;
    }
}

