/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import org.apache.openjpa.kernel.PCState;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;

class PNonTransState
extends PCState {
    private static final Localizer _loc = Localizer.forPackage(PNonTransState.class);

    PNonTransState() {
    }

    @Override
    void initialize(StateManagerImpl context, PCState previous) {
        if (previous == null) {
            return;
        }
        if (previous != PCLEAN) {
            context.proxyFields(true, false);
            context.setDirty(false);
        }
        context.clearSavedFields();
    }

    @Override
    PCState delete(StateManagerImpl context) {
        context.preDelete();
        if (!context.getBroker().isActive()) {
            return PNONTRANSDELETED;
        }
        return PDELETED;
    }

    @Override
    PCState transactional(StateManagerImpl context) {
        if (!context.getBroker().getOptimistic() || context.getBroker().getAutoClear() == 1) {
            context.clearFields();
        }
        return PCLEAN;
    }

    @Override
    PCState release(StateManagerImpl context) {
        return TRANSIENT;
    }

    @Override
    PCState evict(StateManagerImpl context) {
        return HOLLOW;
    }

    @Override
    PCState beforeRead(StateManagerImpl context, int field) {
        context.clearFields();
        return PCLEAN;
    }

    @Override
    PCState beforeWrite(StateManagerImpl context, int field, boolean mutate) {
        return this.beforeWrite(context, field, mutate, false);
    }

    @Override
    PCState beforeOptimisticWrite(StateManagerImpl context, int field, boolean mutate) {
        if (context.getBroker().getAutoClear() == 1) {
            return this.beforeWrite(context, field, mutate, true);
        }
        return PDIRTY;
    }

    private PCState beforeWrite(StateManagerImpl context, int field, boolean mutate, boolean optimistic) {
        if (mutate && !optimistic) {
            Log log = context.getBroker().getConfiguration().getLog("openjpa.Runtime");
            if (log.isWarnEnabled()) {
                log.warn((Object)_loc.get("pessimistic-mutate", (Object)context.getMetaData().getField(field), context.getManagedInstance()));
            }
        } else if (!mutate) {
            if (context.getDirty().length() > 0) {
                context.saveFields(true);
            }
            context.clearFields();
            context.load(null, 0, null, null, true);
        }
        return PDIRTY;
    }

    @Override
    PCState beforeNontransactionalWrite(StateManagerImpl context, int field, boolean mutate) {
        return PNONTRANSDIRTY;
    }

    @Override
    boolean isPersistent() {
        return true;
    }

    public String toString() {
        return "Persistent-Notransactional";
    }
}

