/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.abeth.protocol;

import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.plc4x.java.abeth.configuration.AbEthConfiguration;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationConnectionResponse;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationPacket;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadRequest;
import org.apache.plc4x.java.abeth.readwrite.CIPEncapsulationReadResponse;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandRequestMessage;
import org.apache.plc4x.java.abeth.readwrite.DF1CommandResponseMessageProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.readwrite.DF1RequestProtectedTypedLogicalRead;
import org.apache.plc4x.java.abeth.tag.AbEthTag;
import org.apache.plc4x.java.abeth.tag.AbEthTagHandler;
import org.apache.plc4x.java.api.messages.PlcReadRequest;
import org.apache.plc4x.java.api.messages.PlcReadResponse;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.connection.PlcTagHandler;
import org.apache.plc4x.java.spi.messages.DefaultPlcReadResponse;
import org.apache.plc4x.java.spi.messages.utils.DefaultPlcResponseItem;
import org.apache.plc4x.java.spi.messages.utils.PlcResponseItem;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.DefaultPlcValueHandler;
import org.apache.plc4x.java.spi.values.PlcINT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbEthProtocolLogic
extends Plc4xProtocolBase<CIPEncapsulationPacket>
implements HasConfiguration<AbEthConfiguration> {
    private static final Logger logger = LoggerFactory.getLogger(AbEthProtocolLogic.class);
    public static final Duration REQUEST_TIMEOUT = Duration.ofMillis(10000L);
    private static final List<Short> connectionRequestSenderContext = Arrays.asList((short)0, (short)4, (short)0, (short)5, (short)0, (short)0, (short)0, (short)0);
    private static final List<Short> emptySenderContext = Arrays.asList((short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0, (short)0);
    private AbEthConfiguration configuration;
    private final AtomicInteger transactionCounterGenerator = new AtomicInteger(1);
    private RequestTransactionManager tm;
    private long sessionHandle;

    public void setConfiguration(AbEthConfiguration configuration) {
        this.configuration = configuration;
        this.tm = new RequestTransactionManager(1);
    }

    public PlcTagHandler getTagHandler() {
        return new AbEthTagHandler();
    }

    public void close(ConversationContext<CIPEncapsulationPacket> context) {
        this.tm.shutdown();
    }

    public void onConnect(ConversationContext<CIPEncapsulationPacket> context) {
        logger.debug("Sending Connection Request");
        CIPEncapsulationConnectionRequest connectionRequest = new CIPEncapsulationConnectionRequest(0L, 0L, connectionRequestSenderContext, 0L);
        context.sendRequest((Object)connectionRequest).expectResponse(CIPEncapsulationPacket.class, REQUEST_TIMEOUT).only(CIPEncapsulationConnectionResponse.class).handle(cipEncapsulationConnectionResponse -> {
            this.sessionHandle = cipEncapsulationConnectionResponse.getSessionHandle();
            context.fireConnected();
        });
    }

    public CompletableFuture<PlcReadResponse> read(PlcReadRequest readRequest) {
        DefaultPlcReadResponse plcReadResponse = new DefaultPlcReadResponse(readRequest, new HashMap(readRequest.getNumberOfTags()));
        CompletionStage<Object> combinedFuture = CompletableFuture.completedFuture(plcReadResponse);
        for (String tagName : readRequest.getTagNames()) {
            PlcTag tag = readRequest.getTag(tagName);
            if (!(tag instanceof AbEthTag)) {
                logger.error("The tag should have been of type AbEthTag");
            }
            AbEthTag abEthTag = (AbEthTag)tag;
            DF1RequestProtectedTypedLogicalRead logicalRead = new DF1RequestProtectedTypedLogicalRead(abEthTag.getByteSize(), abEthTag.getFileNumber(), abEthTag.getFileType().getTypeCode(), abEthTag.getElementNumber(), 0);
            int transactionCounter = this.transactionCounterGenerator.incrementAndGet();
            if (this.transactionCounterGenerator.get() == 65535) {
                this.transactionCounterGenerator.set(1);
            }
            DF1CommandRequestMessage requestMessage = new DF1CommandRequestMessage((short)this.configuration.getStation(), 5, 0, transactionCounter, logicalRead);
            CIPEncapsulationReadRequest read = new CIPEncapsulationReadRequest(this.sessionHandle, 0L, emptySenderContext, 0L, requestMessage);
            CompletableFuture future = new CompletableFuture();
            combinedFuture = combinedFuture.thenCombine((CompletionStage)future, (r1, r2) -> plcReadResponse);
            RequestTransactionManager.RequestTransaction transaction = this.tm.startRequest();
            transaction.submit(() -> {
                ConversationContext.ContextHandler contextHandler = this.conversationContext.sendRequest((Object)read).expectResponse(CIPEncapsulationPacket.class, REQUEST_TIMEOUT).onTimeout(future::completeExceptionally).onError((p, e) -> {
                    boolean bl = future.completeExceptionally((Throwable)e);
                }).only(CIPEncapsulationReadResponse.class).check(p -> p.getResponse().getTransactionCounter() == transactionCounter).handle(p -> {
                    PlcResponseItem<PlcValue> response = this.decodeReadResponse((CIPEncapsulationReadResponse)p, abEthTag, tagName);
                    plcReadResponse.add(tagName, response);
                    future.complete(plcReadResponse);
                    transaction.endRequest();
                });
            });
        }
        return combinedFuture;
    }

    private PlcResponseItem<PlcValue> decodeReadResponse(CIPEncapsulationReadResponse plcReadResponse, AbEthTag tag, String tagName) {
        PlcResponseCode responseCode = this.decodeResponseCode(plcReadResponse.getResponse().getStatus());
        PlcValue plcValue = null;
        if (responseCode != PlcResponseCode.OK) {
            return new DefaultPlcResponseItem(responseCode, plcValue);
        }
        try {
            switch (tag.getFileType()) {
                case INTEGER: {
                    if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                        DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                        List<Short> data = df1PTLR.getData();
                        if (data.size() == 1) {
                            plcValue = new PlcINT(data.get(0));
                            break;
                        }
                        plcValue = DefaultPlcValueHandler.of((PlcTag)tag, data);
                    }
                    break;
                }
                case WORD: {
                    if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                        DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                        List<Short> data = df1PTLR.getData();
                        if ((data.get(1) >> 7 & 1) == 0) {
                            plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((data.get(1) << 8) + data.get(0)));
                            break;
                        }
                        plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((((~data.get(1).shortValue() & 0x7F) << 8) + (-data.get(0).shortValue() & 0xFF)) * -1));
                    }
                    break;
                }
                case DWORD: {
                    if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                        DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                        List<Short> data = df1PTLR.getData();
                        if ((data.get(3) >> 7 & 1) == 0) {
                            plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((data.get(3) << 24) + (data.get(2) << 16) + (data.get(1) << 8) + data.get(0)));
                            break;
                        }
                        plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((((~data.get(3).shortValue() & 0x7F) << 24) + ((-data.get(2).shortValue() & 0xFF) << 16) + ((-data.get(1).shortValue() & 0xFF) << 8) + (-data.get(0).shortValue() & 0xFF)) * -1));
                    }
                    break;
                }
                case SINGLEBIT: {
                    if (plcReadResponse.getResponse() instanceof DF1CommandResponseMessageProtectedTypedLogicalRead) {
                        DF1CommandResponseMessageProtectedTypedLogicalRead df1PTLR = (DF1CommandResponseMessageProtectedTypedLogicalRead)plcReadResponse.getResponse();
                        List<Short> data = df1PTLR.getData();
                        if (tag.getBitNumber() < 8) {
                            plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((data.get(0) & 1 << tag.getBitNumber()) != 0 ? 1 : 0));
                            break;
                        }
                        plcValue = DefaultPlcValueHandler.of((PlcTag)tag, (Object)((data.get(1) & 1 << tag.getBitNumber() - 8) != 0 ? 1 : 0));
                    }
                    break;
                }
                default: {
                    logger.warn("Problem during decoding of tag {}: Decoding of file type not implemented; TagInformation: {}", (Object)tagName, (Object)tag);
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.warn("Some other error occurred casting tag {}, TagInformation: {}", new Object[]{tagName, tag, e});
        }
        return new DefaultPlcResponseItem(responseCode, plcValue);
    }

    private PlcResponseCode decodeResponseCode(short status) {
        if (status == 0) {
            return PlcResponseCode.OK;
        }
        return PlcResponseCode.NOT_FOUND;
    }
}

