/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.canopen.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.canopen.readwrite.IndexAddress;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterComplexDefault;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CANOpenMPDO
implements Message {
    protected final short node;
    protected final IndexAddress address;
    protected final byte[] data;

    public CANOpenMPDO(short node, IndexAddress address, byte[] data) {
        this.node = node;
        this.address = address;
        this.data = data;
    }

    public short getNode() {
        return this.node;
    }

    public IndexAddress getAddress() {
        return this.address;
    }

    public byte[] getData() {
        return this.data;
    }

    public void serialize(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CANOpenMPDO", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"node", (Object)this.node, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)new DataWriterComplexDefault(writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"data", (byte[])this.data, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CANOpenMPDO", new WithWriterArgs[0]);
    }

    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    public int getLengthInBits() {
        int lengthInBits = 0;
        CANOpenMPDO _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += this.address.getLengthInBits();
        if (this.data != null) {
            lengthInBits += 8 * this.data.length;
        }
        return lengthInBits;
    }

    public static CANOpenMPDO staticParse(ReadBuffer readBuffer, Object ... args) throws ParseException {
        ReadBuffer positionAware = readBuffer;
        return CANOpenMPDO.staticParse(readBuffer);
    }

    public static CANOpenMPDO staticParse(ReadBuffer readBuffer) throws ParseException {
        readBuffer.pullContext("CANOpenMPDO", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short node = (Short)FieldReaderFactory.readSimpleField((String)"node", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        IndexAddress address = (IndexAddress)FieldReaderFactory.readSimpleField((String)"address", (DataReader)new DataReaderComplexDefault(() -> IndexAddress.staticParse(readBuffer), readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        byte[] data = readBuffer.readByteArray("data", Math.toIntExact(4L), new WithReaderArgs[0]);
        readBuffer.closeContext("CANOpenMPDO", new WithReaderArgs[0]);
        CANOpenMPDO _cANOpenMPDO = new CANOpenMPDO(node, address, data);
        return _cANOpenMPDO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CANOpenMPDO)) {
            return false;
        }
        CANOpenMPDO that = (CANOpenMPDO)o;
        return this.getNode() == that.getNode() && this.getAddress() == that.getAddress() && this.getData() == that.getData();
    }

    public int hashCode() {
        return Objects.hash(this.getNode(), this.getAddress(), this.getData());
    }

    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }
}

