/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.base.configuration;

import org.apache.plc4x.java.spi.configuration.PlcConnectionConfiguration;
import org.apache.plc4x.java.spi.configuration.annotations.ConfigurationParameter;
import org.apache.plc4x.java.spi.configuration.annotations.Description;
import org.apache.plc4x.java.spi.configuration.annotations.Since;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.BooleanDefaultValue;
import org.apache.plc4x.java.spi.configuration.annotations.defaults.IntDefaultValue;
import org.apache.plc4x.java.spi.generation.ByteOrder;

public class EIPConfiguration
implements PlcConnectionConfiguration {
    @ConfigurationParameter
    @IntDefaultValue(value=1)
    @Description(value="Without using routing information the backplane defaults to 1. This is overridden if communicationPath is provided.")
    private int backplane = 1;
    @ConfigurationParameter
    @IntDefaultValue(value=0)
    @Description(value="The slot within the backplane the CPU is located.")
    private int slot = 0;
    @ConfigurationParameter(value="big-endian")
    @BooleanDefaultValue(value=true)
    @Description(value="Configure if the connection should be set to transport data in Big-Endian format, or not.")
    private boolean bigEndian = true;
    @ConfigurationParameter(value="force-unconnected-operation")
    @BooleanDefaultValue(value=false)
    @Description(value="Forces the driver to use unconnected requests.")
    @Since(value="0.13.0")
    private boolean forceUnconnectedOperation = false;

    public int getBackplane() {
        return this.backplane;
    }

    public void setBackplane(int backplane) {
        this.backplane = backplane;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public ByteOrder getByteOrder() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.bigEndian = byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public boolean isForceUnconnectedOperation() {
        return this.forceUnconnectedOperation;
    }

    public void setForceUnconnectedOperation(boolean forceUnconnectedOperation) {
        this.forceUnconnectedOperation = forceUnconnectedOperation;
    }
}

