/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.eip.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.eip.readwrite.EipPacket;
import org.apache.plc4x.java.eip.readwrite.TypeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CipRRData
extends EipPacket
implements Message {
    protected final long interfaceHandle;
    protected final int timeout;
    protected final List<TypeId> typeIds;

    @Override
    public Integer getCommand() {
        return 111;
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    @Override
    public Integer getPacketLength() {
        return 0;
    }

    public CipRRData(long sessionHandle, long status, byte[] senderContext, long options, long interfaceHandle, int timeout, List<TypeId> typeIds) {
        super(sessionHandle, status, senderContext, options);
        this.interfaceHandle = interfaceHandle;
        this.timeout = timeout;
        this.typeIds = typeIds;
    }

    public long getInterfaceHandle() {
        return this.interfaceHandle;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public List<TypeId> getTypeIds() {
        return this.typeIds;
    }

    @Override
    protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CipRRData", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"interfaceHandle", (Object)this.interfaceHandle, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timeout", (Object)this.timeout, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        int typeIdCount = StaticHelper.COUNT(this.getTypeIds());
        FieldWriterFactory.writeImplicitField((String)"typeIdCount", (Object)typeIdCount, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"typeIds", this.typeIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CipRRData", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CipRRData _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 16;
        lengthInBits += 16;
        if (this.typeIds != null) {
            int i = 0;
            for (TypeId element : this.typeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.typeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static EipPacket.EipPacketBuilder staticParseEipPacketBuilder(ReadBuffer readBuffer, Boolean response) throws ParseException {
        readBuffer.pullContext("CipRRData", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long interfaceHandle = (Long)FieldReaderFactory.readSimpleField((String)"interfaceHandle", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int timeout = (Integer)FieldReaderFactory.readSimpleField((String)"timeout", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        int typeIdCount = (Integer)FieldReaderFactory.readImplicitField((String)"typeIdCount", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        List typeIds = FieldReaderFactory.readCountArrayField((String)"typeIds", (DataReader)DataReaderFactory.readComplex(() -> TypeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)typeIdCount, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CipRRData", new WithReaderArgs[0]);
        return new CipRRDataBuilderImpl(interfaceHandle, timeout, typeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CipRRData)) {
            return false;
        }
        CipRRData that = (CipRRData)o;
        return this.getInterfaceHandle() == that.getInterfaceHandle() && this.getTimeout() == that.getTimeout() && this.getTypeIds() == that.getTypeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getInterfaceHandle(), this.getTimeout(), this.getTypeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CipRRDataBuilderImpl
    implements EipPacket.EipPacketBuilder {
        private final long interfaceHandle;
        private final int timeout;
        private final List<TypeId> typeIds;

        public CipRRDataBuilderImpl(long interfaceHandle, int timeout, List<TypeId> typeIds) {
            this.interfaceHandle = interfaceHandle;
            this.timeout = timeout;
            this.typeIds = typeIds;
        }

        @Override
        public CipRRData build(long sessionHandle, long status, byte[] senderContext, long options) {
            CipRRData cipRRData = new CipRRData(sessionHandle, status, senderContext, options, this.interfaceHandle, this.timeout, this.typeIds);
            return cipRRData;
        }
    }
}

