/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.modbus.base.protocol;

import java.time.Duration;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.api.model.PlcTag;
import org.apache.plc4x.java.api.types.PlcResponseCode;
import org.apache.plc4x.java.api.value.PlcValue;
import org.apache.plc4x.java.modbus.base.tag.ModbusTag;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagCoil;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagDiscreteInput;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagExtendedRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagHoldingRegister;
import org.apache.plc4x.java.modbus.base.tag.ModbusTagInputRegister;
import org.apache.plc4x.java.modbus.readwrite.DataItem;
import org.apache.plc4x.java.modbus.readwrite.DriverType;
import org.apache.plc4x.java.modbus.readwrite.ModbusADU;
import org.apache.plc4x.java.modbus.readwrite.ModbusDataType;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDU;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUError;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadCoilsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadDiscreteInputsResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadFileRecordResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadHoldingRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUReadInputRegistersResponse;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteFileRecordRequestItem;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleCoilsRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteMultipleHoldingRegistersRequest;
import org.apache.plc4x.java.modbus.readwrite.ModbusPDUWriteSingleRegisterRequest;
import org.apache.plc4x.java.modbus.types.ModbusByteOrder;
import org.apache.plc4x.java.spi.ConversationContext;
import org.apache.plc4x.java.spi.Plc4xProtocolBase;
import org.apache.plc4x.java.spi.generation.ByteOrder;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferByteBased;
import org.apache.plc4x.java.spi.transaction.RequestTransactionManager;
import org.apache.plc4x.java.spi.values.PlcBOOL;
import org.apache.plc4x.java.spi.values.PlcList;
import org.apache.plc4x.java.spi.values.PlcRawByteArray;

public abstract class ModbusProtocolLogic<T extends ModbusADU>
extends Plc4xProtocolBase<T> {
    protected final DriverType driverType;
    protected Duration requestTimeout;
    protected short unitIdentifier;
    protected PlcTag pingAddress;
    protected ModbusByteOrder defaultPayloadByteOrder;
    protected RequestTransactionManager tm;
    protected final AtomicInteger transactionIdentifierGenerator = new AtomicInteger(1);
    protected static final int FC_EXTENDED_REGISTERS_GROUP_HEADER_LENGTH = 2;
    protected static final int FC_EXTENDED_REGISTERS_FILE_RECORD_LENGTH = 10000;

    public ModbusProtocolLogic(DriverType driverType) {
        this.driverType = driverType;
    }

    public void close(ConversationContext<T> context) {
    }

    protected void decode(ConversationContext<T> context, T msg) throws Exception {
        super.decode(context, msg);
    }

    protected PlcResponseCode getErrorCode(ModbusPDUError errorResponse) {
        switch (errorResponse.getExceptionCode()) {
            case ILLEGAL_FUNCTION: {
                return PlcResponseCode.UNSUPPORTED;
            }
            case ILLEGAL_DATA_ADDRESS: {
                return PlcResponseCode.INVALID_ADDRESS;
            }
            case ILLEGAL_DATA_VALUE: {
                return PlcResponseCode.INVALID_DATA;
            }
            case SLAVE_DEVICE_FAILURE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case ACKNOWLEDGE: {
                return PlcResponseCode.OK;
            }
            case SLAVE_DEVICE_BUSY: {
                return PlcResponseCode.REMOTE_BUSY;
            }
            case NEGATIVE_ACKNOWLEDGE: {
                return PlcResponseCode.REMOTE_ERROR;
            }
            case MEMORY_PARITY_ERROR: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_PATH_UNAVAILABLE: {
                return PlcResponseCode.INTERNAL_ERROR;
            }
            case GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND: {
                return PlcResponseCode.REMOTE_ERROR;
            }
        }
        return PlcResponseCode.INTERNAL_ERROR;
    }

    protected short getUnitId(PlcTag tag) {
        if (tag instanceof ModbusTag) {
            Short unitId = ((ModbusTag)tag).getUnitId();
            return unitId == null ? this.unitIdentifier : unitId;
        }
        return this.unitIdentifier;
    }

    protected ModbusPDU getReadRequestPdu(PlcTag tag) {
        if (tag instanceof ModbusTagDiscreteInput) {
            ModbusTagDiscreteInput discreteInput = (ModbusTagDiscreteInput)tag;
            return new ModbusPDUReadDiscreteInputsRequest(discreteInput.getAddress(), discreteInput.getNumberOfElements());
        }
        if (tag instanceof ModbusTagCoil) {
            ModbusTagCoil coil = (ModbusTagCoil)tag;
            return new ModbusPDUReadCoilsRequest(coil.getAddress(), coil.getNumberOfElements());
        }
        if (tag instanceof ModbusTagInputRegister) {
            ModbusTagInputRegister inputRegister = (ModbusTagInputRegister)tag;
            return new ModbusPDUReadInputRegistersRequest(inputRegister.getAddress(), Math.max(inputRegister.getLengthWords(), 1));
        }
        if (tag instanceof ModbusTagHoldingRegister) {
            ModbusTagHoldingRegister holdingRegister = (ModbusTagHoldingRegister)tag;
            return new ModbusPDUReadHoldingRegistersRequest(holdingRegister.getAddress(), Math.max(holdingRegister.getLengthWords(), 1));
        }
        if (tag instanceof ModbusTagExtendedRegister) {
            List<ModbusPDUReadFileRecordRequestItem> itemArray;
            ModbusTagExtendedRegister extendedRegister = (ModbusTagExtendedRegister)tag;
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                ModbusPDUReadFileRecordRequestItem group1 = new ModbusPDUReadFileRecordRequestItem(6, group1FileNumber, group1Address, group1Quantity);
                ModbusPDUReadFileRecordRequestItem group2 = new ModbusPDUReadFileRecordRequestItem(6, group2FileNumber, group2Address, group2Quantity);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUReadFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported read tag type " + tag.getClass().getName());
    }

    protected ModbusPDU getWriteRequestPdu(PlcTag tag, PlcValue plcValue) {
        if (tag instanceof ModbusTagCoil) {
            ModbusPDUWriteMultipleCoilsRequest request;
            ModbusTagCoil coil = (ModbusTagCoil)tag;
            ModbusByteOrder byteOrder = this.defaultPayloadByteOrder;
            if (coil.getByteOrder() != null) {
                byteOrder = coil.getByteOrder();
            }
            if ((request = new ModbusPDUWriteMultipleCoilsRequest(coil.getAddress(), coil.getNumberOfElements(), this.fromPlcValue(tag, plcValue, byteOrder))).getQuantity() == coil.getNumberOfElements()) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested bytes (" + request.getQuantity() + ") doesn't match number of requested addresses (" + coil.getNumberOfElements() + ")");
        }
        if (tag instanceof ModbusTagHoldingRegister) {
            byte[] bytes;
            ModbusTagHoldingRegister holdingRegister = (ModbusTagHoldingRegister)tag;
            ModbusByteOrder byteOrder = this.defaultPayloadByteOrder;
            if (holdingRegister.getByteOrder() != null) {
                byteOrder = holdingRegister.getByteOrder();
            }
            if ((bytes = this.fromPlcValue(tag, plcValue, byteOrder)).length == 2) {
                int value = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
                return new ModbusPDUWriteSingleRegisterRequest(holdingRegister.getAddress(), value);
            }
            ModbusPDUWriteMultipleHoldingRegistersRequest request = new ModbusPDUWriteMultipleHoldingRegistersRequest(holdingRegister.getAddress(), holdingRegister.getLengthWords(), bytes);
            if (request.getValue().length == holdingRegister.getLengthWords() * 2) {
                return request;
            }
            throw new PlcRuntimeException("Number of requested values (" + request.getValue().length / 2 + ") doesn't match number of requested addresses (" + holdingRegister.getLengthWords() + ")");
        }
        if (tag instanceof ModbusTagExtendedRegister) {
            List<ModbusPDUWriteFileRecordRequestItem> itemArray;
            ModbusTagExtendedRegister extendedRegister = (ModbusTagExtendedRegister)tag;
            ModbusByteOrder byteOrder = this.defaultPayloadByteOrder;
            if (extendedRegister.getByteOrder() != null) {
                byteOrder = extendedRegister.getByteOrder();
            }
            int group1Address = extendedRegister.getAddress() % 10000;
            int group2Address = 0;
            short group1FileNumber = (short)(Math.floor((float)extendedRegister.getAddress() / 10000.0f) + 1.0);
            if (group1Address + extendedRegister.getLengthWords() <= 10000) {
                int group1Quantity = extendedRegister.getLengthWords();
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, this.fromPlcValue(tag, plcValue, byteOrder));
                itemArray = Collections.singletonList(group1);
            } else {
                int group1Quantity = 10000 - group1Address;
                int group2Quantity = extendedRegister.getLengthWords() - group1Quantity;
                short group2FileNumber = (short)(group1FileNumber + 1);
                byte[] plcValue1 = ArrayUtils.subarray((byte[])this.fromPlcValue(tag, plcValue, byteOrder), (int)0, (int)group1Quantity);
                byte[] plcValue2 = ArrayUtils.subarray((byte[])this.fromPlcValue(tag, plcValue, byteOrder), (int)group1Quantity, (int)this.fromPlcValue(tag, plcValue, byteOrder).length);
                ModbusPDUWriteFileRecordRequestItem group1 = new ModbusPDUWriteFileRecordRequestItem(6, group1FileNumber, group1Address, plcValue1);
                ModbusPDUWriteFileRecordRequestItem group2 = new ModbusPDUWriteFileRecordRequestItem(6, group2FileNumber, group2Address, plcValue2);
                itemArray = Arrays.asList(group1, group2);
            }
            return new ModbusPDUWriteFileRecordRequest(itemArray);
        }
        throw new PlcRuntimeException("Unsupported write tag type " + tag.getClass().getName());
    }

    protected PlcValue toPlcValue(ModbusPDU request, ModbusPDU response, ModbusDataType dataType, ModbusByteOrder byteOrder) throws ParseException {
        if (request instanceof ModbusPDUReadDiscreteInputsRequest) {
            if (!(response instanceof ModbusPDUReadDiscreteInputsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadDiscreteInputsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadDiscreteInputsResponse resp = (ModbusPDUReadDiscreteInputsResponse)response;
            return new PlcRawByteArray(resp.getValue());
        }
        if (request instanceof ModbusPDUReadCoilsRequest) {
            if (!(response instanceof ModbusPDUReadCoilsResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadCoilsResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadCoilsResponse resp = (ModbusPDUReadCoilsResponse)response;
            return new PlcRawByteArray(resp.getValue());
        }
        if (request instanceof ModbusPDUReadInputRegistersRequest) {
            if (!(response instanceof ModbusPDUReadInputRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadInputRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadInputRegistersResponse resp = (ModbusPDUReadInputRegistersResponse)response;
            return new PlcRawByteArray(resp.getValue());
        }
        if (request instanceof ModbusPDUReadHoldingRegistersRequest) {
            if (!(response instanceof ModbusPDUReadHoldingRegistersResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadHoldingRegistersResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadHoldingRegistersResponse resp = (ModbusPDUReadHoldingRegistersResponse)response;
            return new PlcRawByteArray(resp.getValue());
        }
        if (request instanceof ModbusPDUReadFileRecordRequest) {
            if (!(response instanceof ModbusPDUReadFileRecordResponse)) {
                throw new PlcRuntimeException("Unexpected response type. Expected ModbusPDUReadFileRecordResponse, but got " + response.getClass().getName());
            }
            ModbusPDUReadFileRecordResponse resp = (ModbusPDUReadFileRecordResponse)response;
            return new PlcRawByteArray(resp.getItems().get(0).getData());
        }
        return null;
    }

    protected byte[] fromPlcValue(PlcTag tag, PlcValue plcValue, ModbusByteOrder byteOrder) {
        ModbusDataType tagDataType = ((ModbusTag)tag).getDataType();
        try {
            if (tag instanceof ModbusTagCoil) {
                if (plcValue instanceof PlcBOOL) {
                    byte byteValue = (byte)(plcValue.getBoolean() ? 1 : 0);
                    return new byte[]{byteValue};
                }
                if (plcValue instanceof PlcList) {
                    int i;
                    PlcList valueList = (PlcList)plcValue;
                    WriteBufferByteBased wb = this.getWriteBuffer((plcValue.getLength() - 1) / 8 + 1, byteOrder);
                    int paddingBits = 8 - plcValue.getLength() % 8;
                    if (paddingBits < 8) {
                        i = 0;
                        while (i < paddingBits) {
                            wb.writeBit(false, new WithWriterArgs[0]);
                            ++i;
                        }
                    }
                    i = 0;
                    while (i < plcValue.getLength()) {
                        PlcValue value = valueList.getIndex(plcValue.getLength() - 1 - i);
                        if (!(value instanceof PlcBOOL)) {
                            throw new PlcRuntimeException("Expecting only BOOL values when writing coils.");
                        }
                        PlcBOOL boolValue = (PlcBOOL)value;
                        wb.writeBit(boolValue.getBoolean(), new WithWriterArgs[0]);
                        ++i;
                    }
                    byte[] bytes = wb.getBytes();
                    if (byteOrder == ModbusByteOrder.BIG_ENDIAN_BYTE_SWAP || byteOrder == ModbusByteOrder.LITTLE_ENDIAN_BYTE_SWAP) {
                        bytes = ModbusProtocolLogic.byteSwap(bytes);
                    }
                    ArrayUtils.reverse((byte[])bytes);
                    return bytes;
                }
                throw new PlcRuntimeException("Expecting only BOOL or List values when writing coils.");
            }
            if (plcValue instanceof PlcList) {
                WriteBufferByteBased writeBuffer = this.getWriteBuffer(DataItem.getLengthInBytes(plcValue, tagDataType, plcValue.getLength(), byteOrder == ModbusByteOrder.BIG_ENDIAN), byteOrder);
                DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, tagDataType, plcValue.getLength(), byteOrder == ModbusByteOrder.BIG_ENDIAN);
                byte[] data = writeBuffer.getBytes();
                if (byteOrder == ModbusByteOrder.BIG_ENDIAN_BYTE_SWAP || byteOrder == ModbusByteOrder.LITTLE_ENDIAN_BYTE_SWAP) {
                    data = ModbusProtocolLogic.byteSwap(data);
                }
                if (((ModbusTag)tag).getDataType() == ModbusDataType.BOOL) {
                    byte[] bytes = new byte[data.length];
                    int i = 0;
                    while (i < data.length) {
                        bytes[i] = this.reverseBitsOfByte(data[i]);
                        ++i;
                    }
                    return bytes;
                }
                return data;
            }
            WriteBufferByteBased writeBuffer = this.getWriteBuffer(DataItem.getLengthInBytes(plcValue, tagDataType, plcValue.getLength(), byteOrder == ModbusByteOrder.BIG_ENDIAN), byteOrder);
            DataItem.staticSerialize((WriteBuffer)writeBuffer, plcValue, tagDataType, plcValue.getLength(), byteOrder == ModbusByteOrder.BIG_ENDIAN);
            byte[] bytes = writeBuffer.getBytes();
            if (byteOrder == ModbusByteOrder.BIG_ENDIAN_BYTE_SWAP || byteOrder == ModbusByteOrder.LITTLE_ENDIAN_BYTE_SWAP) {
                bytes = ModbusProtocolLogic.byteSwap(bytes);
            }
            return bytes;
        }
        catch (SerializationException e) {
            throw new PlcRuntimeException("Unable to parse PlcValue :- " + (Object)((Object)e));
        }
    }

    protected byte reverseBitsOfByte(byte b) {
        BitSet bits = BitSet.valueOf(new byte[]{b});
        BitSet reverse = BitSet.valueOf(new byte[]{-1});
        int j = 0;
        while (j < 8) {
            reverse.set(j, bits.get(7 - j));
            ++j;
        }
        return Arrays.copyOf(reverse.toByteArray(), 1)[0];
    }

    private WriteBufferByteBased getWriteBuffer(int size, ModbusByteOrder byteOrder) {
        switch (byteOrder) {
            case LITTLE_ENDIAN: {
                return new WriteBufferByteBased(size, ByteOrder.LITTLE_ENDIAN);
            }
            case BIG_ENDIAN_BYTE_SWAP: {
                return new WriteBufferByteBased(size, ByteOrder.BIG_ENDIAN);
            }
            case LITTLE_ENDIAN_BYTE_SWAP: {
                return new WriteBufferByteBased(size, ByteOrder.LITTLE_ENDIAN);
            }
        }
        return new WriteBufferByteBased(size, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] byteSwap(byte[] in) {
        byte[] out = new byte[in.length];
        int i = 0;
        while (i < out.length) {
            out[i] = in[i + 1];
            out[i + 1] = in[i];
            i += 2;
        }
        return out;
    }
}

