/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.context;

import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.RandomUtils;
import org.apache.plc4x.java.opcua.context.CertificateKeyPair;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateGenerator<PKCS10CertificateRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CertificateGenerator.class);
    private static final String APPURI = "urn:eclipse:milo:plc4x:server";

    public static CertificateKeyPair generateCertificate() {
        KeyPairGenerator kpg = null;
        try {
            kpg = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Security Algorithim is unsupported for certificate");
            return null;
        }
        kpg.initialize(2048);
        KeyPair caKeys = kpg.generateKeyPair();
        KeyPair userKeys = kpg.generateKeyPair();
        X500NameBuilder nameBuilder = new X500NameBuilder();
        nameBuilder.addRDN(BCStyle.CN, "Apache PLC4X Driver Client");
        nameBuilder.addRDN(BCStyle.O, "Apache Software Foundation");
        nameBuilder.addRDN(BCStyle.OU, "dev");
        nameBuilder.addRDN(BCStyle.L, "");
        nameBuilder.addRDN(BCStyle.ST, "DE");
        nameBuilder.addRDN(BCStyle.C, "US");
        BigInteger serial = new BigInteger(RandomUtils.nextBytes((int)40));
        Calendar calender = Calendar.getInstance();
        calender.add(5, -1);
        Date startDate = calender.getTime();
        calender.add(5, 9125);
        Date expiryDate = calender.getTime();
        KeyPairGenerator generator = null;
        try {
            generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(2048, new SecureRandom());
            KeyPair keyPair = generator.generateKeyPair();
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded());
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(nameBuilder.build(), serial, startDate, expiryDate, Locale.ENGLISH, nameBuilder.build(), subjectPublicKeyInfo);
            GeneralName[] gnArray = new GeneralName[]{new GeneralName(2, InetAddress.getLocalHost().getHostName()), new GeneralName(6, APPURI)};
            certificateBuilder.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new JcaX509ExtensionUtils().createAuthorityKeyIdentifier(keyPair.getPublic()));
            certificateBuilder.addExtension(Extension.extendedKeyUsage, false, (ASN1Encodable)new ExtendedKeyUsage(new KeyPurposeId[]{KeyPurposeId.id_kp_clientAuth, KeyPurposeId.id_kp_serverAuth}));
            certificateBuilder.addExtension(Extension.keyUsage, false, (ASN1Encodable)new KeyUsage(252));
            certificateBuilder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(true));
            GeneralNames subjectAltNames = GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable[])gnArray));
            certificateBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAltNames);
            ContentSigner sigGen = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(keyPair.getPrivate());
            X509CertificateHolder certificateHolder = certificateBuilder.build(sigGen);
            JcaX509CertificateConverter certificateConvertor = new JcaX509CertificateConverter();
            certificateConvertor.setProvider((Provider)new BouncyCastleProvider());
            CertificateKeyPair ckp = new CertificateKeyPair(keyPair, certificateConvertor.getCertificate(certificateHolder));
            return ckp;
        }
        catch (Exception e) {
            LOGGER.error("Security Algorithm is unsupported for certificate");
            return null;
        }
    }
}

