/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.AxisScaleEnumeration;
import org.apache.plc4x.java.opcua.readwrite.EUInformation;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.opcua.readwrite.Range;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class AxisInformation
extends ExtensionObjectDefinition
implements Message {
    protected final EUInformation engineeringUnits;
    protected final Range eURange;
    protected final LocalizedText title;
    protected final AxisScaleEnumeration axisScaleType;
    protected final List<Double> axisSteps;

    @Override
    public Integer getExtensionId() {
        return 12081;
    }

    public AxisInformation(EUInformation engineeringUnits, Range eURange, LocalizedText title, AxisScaleEnumeration axisScaleType, List<Double> axisSteps) {
        this.engineeringUnits = engineeringUnits;
        this.eURange = eURange;
        this.title = title;
        this.axisScaleType = axisScaleType;
        this.axisSteps = axisSteps;
    }

    public EUInformation getEngineeringUnits() {
        return this.engineeringUnits;
    }

    public Range getEURange() {
        return this.eURange;
    }

    public LocalizedText getTitle() {
        return this.title;
    }

    public AxisScaleEnumeration getAxisScaleType() {
        return this.axisScaleType;
    }

    public List<Double> getAxisSteps() {
        return this.axisSteps;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("AxisInformation", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"engineeringUnits", (Object)this.engineeringUnits, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"eURange", (Object)this.eURange, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"title", (Object)this.title, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"axisScaleType", (String)"AxisScaleEnumeration", (Object)((Object)this.axisScaleType), (DataWriter)DataWriterFactory.writeEnum(AxisScaleEnumeration::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAxisSteps = this.getAxisSteps() == null ? -1 : StaticHelper.COUNT(this.getAxisSteps());
        FieldWriterFactory.writeImplicitField((String)"noOfAxisSteps", (Object)noOfAxisSteps, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"axisSteps", this.axisSteps, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("AxisInformation", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        AxisInformation _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.engineeringUnits.getLengthInBits();
        lengthInBits += this.eURange.getLengthInBits();
        lengthInBits += this.title.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.axisSteps != null) {
            lengthInBits += 64 * this.axisSteps.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("AxisInformation", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        EUInformation engineeringUnits = (EUInformation)FieldReaderFactory.readSimpleField((String)"engineeringUnits", (DataReader)DataReaderFactory.readComplex(() -> (EUInformation)ExtensionObjectDefinition.staticParse(readBuffer, 889), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Range eURange = (Range)FieldReaderFactory.readSimpleField((String)"eURange", (DataReader)DataReaderFactory.readComplex(() -> (Range)ExtensionObjectDefinition.staticParse(readBuffer, 886), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText title = (LocalizedText)FieldReaderFactory.readSimpleField((String)"title", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        AxisScaleEnumeration axisScaleType = (AxisScaleEnumeration)((Object)FieldReaderFactory.readEnumField((String)"axisScaleType", (String)"AxisScaleEnumeration", (DataReader)DataReaderFactory.readEnum(AxisScaleEnumeration::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        int noOfAxisSteps = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAxisSteps", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List axisSteps = FieldReaderFactory.readCountArrayField((String)"axisSteps", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (long)noOfAxisSteps, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("AxisInformation", new WithReaderArgs[0]);
        return new AxisInformationBuilderImpl(engineeringUnits, eURange, title, axisScaleType, axisSteps);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AxisInformation)) {
            return false;
        }
        AxisInformation that = (AxisInformation)o;
        return this.getEngineeringUnits() == that.getEngineeringUnits() && this.getEURange() == that.getEURange() && this.getTitle() == that.getTitle() && this.getAxisScaleType() == that.getAxisScaleType() && this.getAxisSteps() == that.getAxisSteps() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getEngineeringUnits(), this.getEURange(), this.getTitle(), this.getAxisScaleType(), this.getAxisSteps()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class AxisInformationBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final EUInformation engineeringUnits;
        private final Range eURange;
        private final LocalizedText title;
        private final AxisScaleEnumeration axisScaleType;
        private final List<Double> axisSteps;

        public AxisInformationBuilderImpl(EUInformation engineeringUnits, Range eURange, LocalizedText title, AxisScaleEnumeration axisScaleType, List<Double> axisSteps) {
            this.engineeringUnits = engineeringUnits;
            this.eURange = eURange;
            this.title = title;
            this.axisScaleType = axisScaleType;
            this.axisSteps = axisSteps;
        }

        @Override
        public AxisInformation build() {
            AxisInformation axisInformation = new AxisInformation(this.engineeringUnits, this.eURange, this.title, this.axisScaleType, this.axisSteps);
            return axisInformation;
        }
    }
}

