/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.Payload;
import org.apache.plc4x.java.opcua.readwrite.SequenceHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class BinaryPayload
extends Payload
implements Message {
    protected final byte[] payload;

    @Override
    public Boolean getBinary() {
        return true;
    }

    public BinaryPayload(SequenceHeader sequenceHeader, byte[] payload) {
        super(sequenceHeader);
        this.payload = payload;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    protected void serializePayloadChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("BinaryPayload", new WithWriterArgs[0]);
        FieldWriterFactory.writeByteArrayField((String)"payload", (byte[])this.payload, (DataWriter)DataWriterFactory.writeByteArray((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("BinaryPayload", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        BinaryPayload _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.payload != null) {
            lengthInBits += 8 * this.payload.length;
        }
        return lengthInBits;
    }

    public static Payload.PayloadBuilder staticParsePayloadBuilder(ReadBuffer readBuffer, Boolean binary, Long byteCount) throws ParseException {
        readBuffer.pullContext("BinaryPayload", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        byte[] payload = readBuffer.readByteArray("payload", Math.toIntExact(byteCount), new WithReaderArgs[0]);
        readBuffer.closeContext("BinaryPayload", new WithReaderArgs[0]);
        return new BinaryPayloadBuilderImpl(payload);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BinaryPayload)) {
            return false;
        }
        BinaryPayload that = (BinaryPayload)o;
        return this.getPayload() == that.getPayload() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPayload());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class BinaryPayloadBuilderImpl
    implements Payload.PayloadBuilder {
        private final byte[] payload;

        public BinaryPayloadBuilderImpl(byte[] payload) {
            this.payload = payload;
        }

        @Override
        public BinaryPayload build(SequenceHeader sequenceHeader) {
            BinaryPayload binaryPayload = new BinaryPayload(sequenceHeader, this.payload);
            return binaryPayload;
        }
    }
}

