/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.TrustListValidationOptions;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CertificateGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<KeyValuePair> recordProperties;
    protected final NodeId purpose;
    protected final List<NodeId> certificateTypes;
    protected final List<Boolean> isCertificateAssigned;
    protected final TrustListValidationOptions validationOptions;

    @Override
    public Integer getExtensionId() {
        return 15438;
    }

    public CertificateGroupDataType(PascalString name, List<KeyValuePair> recordProperties, NodeId purpose, List<NodeId> certificateTypes, List<Boolean> isCertificateAssigned, TrustListValidationOptions validationOptions) {
        this.name = name;
        this.recordProperties = recordProperties;
        this.purpose = purpose;
        this.certificateTypes = certificateTypes;
        this.isCertificateAssigned = isCertificateAssigned;
        this.validationOptions = validationOptions;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<KeyValuePair> getRecordProperties() {
        return this.recordProperties;
    }

    public NodeId getPurpose() {
        return this.purpose;
    }

    public List<NodeId> getCertificateTypes() {
        return this.certificateTypes;
    }

    public List<Boolean> getIsCertificateAssigned() {
        return this.isCertificateAssigned;
    }

    public TrustListValidationOptions getValidationOptions() {
        return this.validationOptions;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CertificateGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRecordProperties = this.getRecordProperties() == null ? -1 : StaticHelper.COUNT(this.getRecordProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfRecordProperties", (Object)noOfRecordProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"recordProperties", this.recordProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"purpose", (Object)this.purpose, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfCertificateTypes = this.getCertificateTypes() == null ? -1 : StaticHelper.COUNT(this.getCertificateTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfCertificateTypes", (Object)noOfCertificateTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"certificateTypes", this.certificateTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfIsCertificateAssigned = this.getIsCertificateAssigned() == null ? -1 : StaticHelper.COUNT(this.getIsCertificateAssigned());
        FieldWriterFactory.writeImplicitField((String)"noOfIsCertificateAssigned", (Object)noOfIsCertificateAssigned, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"isCertificateAssigned", this.isCertificateAssigned, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"validationOptions", (String)"TrustListValidationOptions", (Object)((Object)this.validationOptions), (DataWriter)DataWriterFactory.writeEnum(TrustListValidationOptions::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CertificateGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        CertificateGroupDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.recordProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.recordProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.recordProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += this.purpose.getLengthInBits();
        lengthInBits += 32;
        if (this.certificateTypes != null) {
            i = 0;
            for (NodeId nodeId : this.certificateTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.certificateTypes.size());
                lengthInBits += nodeId.getLengthInBits();
            }
        }
        lengthInBits += 32;
        lengthInBits += 7;
        if (this.isCertificateAssigned != null) {
            lengthInBits += 1 * this.isCertificateAssigned.size();
        }
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("CertificateGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRecordProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRecordProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List recordProperties = FieldReaderFactory.readCountArrayField((String)"recordProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfRecordProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId purpose = (NodeId)FieldReaderFactory.readSimpleField((String)"purpose", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfCertificateTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfCertificateTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List certificateTypes = FieldReaderFactory.readCountArrayField((String)"certificateTypes", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfCertificateTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfIsCertificateAssigned = (Integer)FieldReaderFactory.readImplicitField((String)"noOfIsCertificateAssigned", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        List isCertificateAssigned = FieldReaderFactory.readCountArrayField((String)"isCertificateAssigned", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (long)noOfIsCertificateAssigned, (WithReaderArgs[])new WithReaderArgs[0]);
        TrustListValidationOptions validationOptions = (TrustListValidationOptions)((Object)FieldReaderFactory.readEnumField((String)"validationOptions", (String)"TrustListValidationOptions", (DataReader)DataReaderFactory.readEnum(TrustListValidationOptions::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        readBuffer.closeContext("CertificateGroupDataType", new WithReaderArgs[0]);
        return new CertificateGroupDataTypeBuilderImpl(name, recordProperties, purpose, certificateTypes, isCertificateAssigned, validationOptions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CertificateGroupDataType)) {
            return false;
        }
        CertificateGroupDataType that = (CertificateGroupDataType)o;
        return this.getName() == that.getName() && this.getRecordProperties() == that.getRecordProperties() && this.getPurpose() == that.getPurpose() && this.getCertificateTypes() == that.getCertificateTypes() && this.getIsCertificateAssigned() == that.getIsCertificateAssigned() && this.getValidationOptions() == that.getValidationOptions() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getName(), this.getRecordProperties(), this.getPurpose(), this.getCertificateTypes(), this.getIsCertificateAssigned(), this.getValidationOptions()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CertificateGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<KeyValuePair> recordProperties;
        private final NodeId purpose;
        private final List<NodeId> certificateTypes;
        private final List<Boolean> isCertificateAssigned;
        private final TrustListValidationOptions validationOptions;

        public CertificateGroupDataTypeBuilderImpl(PascalString name, List<KeyValuePair> recordProperties, NodeId purpose, List<NodeId> certificateTypes, List<Boolean> isCertificateAssigned, TrustListValidationOptions validationOptions) {
            this.name = name;
            this.recordProperties = recordProperties;
            this.purpose = purpose;
            this.certificateTypes = certificateTypes;
            this.isCertificateAssigned = isCertificateAssigned;
            this.validationOptions = validationOptions;
        }

        @Override
        public CertificateGroupDataType build() {
            CertificateGroupDataType certificateGroupDataType = new CertificateGroupDataType(this.name, this.recordProperties, this.purpose, this.certificateTypes, this.isCertificateAssigned, this.validationOptions);
            return certificateGroupDataType;
        }
    }
}

