/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ContentFilterElementResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final List<StatusCode> operandStatusCodes;
    protected final List<DiagnosticInfo> operandDiagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 606;
    }

    public ContentFilterElementResult(StatusCode statusCode, List<StatusCode> operandStatusCodes, List<DiagnosticInfo> operandDiagnosticInfos) {
        this.statusCode = statusCode;
        this.operandStatusCodes = operandStatusCodes;
        this.operandDiagnosticInfos = operandDiagnosticInfos;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public List<StatusCode> getOperandStatusCodes() {
        return this.operandStatusCodes;
    }

    public List<DiagnosticInfo> getOperandDiagnosticInfos() {
        return this.operandDiagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ContentFilterElementResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfOperandStatusCodes = this.getOperandStatusCodes() == null ? -1 : StaticHelper.COUNT(this.getOperandStatusCodes());
        FieldWriterFactory.writeImplicitField((String)"noOfOperandStatusCodes", (Object)noOfOperandStatusCodes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"operandStatusCodes", this.operandStatusCodes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfOperandDiagnosticInfos = this.getOperandDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getOperandDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfOperandDiagnosticInfos", (Object)noOfOperandDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"operandDiagnosticInfos", this.operandDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ContentFilterElementResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        ContentFilterElementResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.operandStatusCodes != null) {
            i = 0;
            for (StatusCode statusCode : this.operandStatusCodes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.operandStatusCodes.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.operandDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.operandDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.operandDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ContentFilterElementResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfOperandStatusCodes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfOperandStatusCodes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List operandStatusCodes = FieldReaderFactory.readCountArrayField((String)"operandStatusCodes", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfOperandStatusCodes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfOperandDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfOperandDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List operandDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"operandDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfOperandDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ContentFilterElementResult", new WithReaderArgs[0]);
        return new ContentFilterElementResultBuilderImpl(statusCode, operandStatusCodes, operandDiagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentFilterElementResult)) {
            return false;
        }
        ContentFilterElementResult that = (ContentFilterElementResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getOperandStatusCodes() == that.getOperandStatusCodes() && this.getOperandDiagnosticInfos() == that.getOperandDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getOperandStatusCodes(), this.getOperandDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ContentFilterElementResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final List<StatusCode> operandStatusCodes;
        private final List<DiagnosticInfo> operandDiagnosticInfos;

        public ContentFilterElementResultBuilderImpl(StatusCode statusCode, List<StatusCode> operandStatusCodes, List<DiagnosticInfo> operandDiagnosticInfos) {
            this.statusCode = statusCode;
            this.operandStatusCodes = operandStatusCodes;
            this.operandDiagnosticInfos = operandDiagnosticInfos;
        }

        @Override
        public ContentFilterElementResult build() {
            ContentFilterElementResult contentFilterElementResult = new ContentFilterElementResult(this.statusCode, this.operandStatusCodes, this.operandDiagnosticInfos);
            return contentFilterElementResult;
        }
    }
}

