/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.MonitoredItemCreateRequest;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.TimestampsToReturn;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class CreateMonitoredItemsRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final long subscriptionId;
    protected final TimestampsToReturn timestampsToReturn;
    protected final List<MonitoredItemCreateRequest> itemsToCreate;

    @Override
    public Integer getExtensionId() {
        return 751;
    }

    public CreateMonitoredItemsRequest(RequestHeader requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.timestampsToReturn = timestampsToReturn;
        this.itemsToCreate = itemsToCreate;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public TimestampsToReturn getTimestampsToReturn() {
        return this.timestampsToReturn;
    }

    public List<MonitoredItemCreateRequest> getItemsToCreate() {
        return this.itemsToCreate;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("CreateMonitoredItemsRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"subscriptionId", (Object)this.subscriptionId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (Object)((Object)this.timestampsToReturn), (DataWriter)DataWriterFactory.writeEnum(TimestampsToReturn::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfItemsToCreate = this.getItemsToCreate() == null ? -1 : StaticHelper.COUNT(this.getItemsToCreate());
        FieldWriterFactory.writeImplicitField((String)"noOfItemsToCreate", (Object)noOfItemsToCreate, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"itemsToCreate", this.itemsToCreate, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("CreateMonitoredItemsRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        CreateMonitoredItemsRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.itemsToCreate != null) {
            int i = 0;
            for (MonitoredItemCreateRequest element : this.itemsToCreate) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.itemsToCreate.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("CreateMonitoredItemsRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long subscriptionId = (Long)FieldReaderFactory.readSimpleField((String)"subscriptionId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        TimestampsToReturn timestampsToReturn = (TimestampsToReturn)((Object)FieldReaderFactory.readEnumField((String)"timestampsToReturn", (String)"TimestampsToReturn", (DataReader)DataReaderFactory.readEnum(TimestampsToReturn::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        int noOfItemsToCreate = (Integer)FieldReaderFactory.readImplicitField((String)"noOfItemsToCreate", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List itemsToCreate = FieldReaderFactory.readCountArrayField((String)"itemsToCreate", (DataReader)DataReaderFactory.readComplex(() -> (MonitoredItemCreateRequest)ExtensionObjectDefinition.staticParse(readBuffer, 745), (ReadBuffer)readBuffer), (long)noOfItemsToCreate, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("CreateMonitoredItemsRequest", new WithReaderArgs[0]);
        return new CreateMonitoredItemsRequestBuilderImpl(requestHeader, subscriptionId, timestampsToReturn, itemsToCreate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMonitoredItemsRequest)) {
            return false;
        }
        CreateMonitoredItemsRequest that = (CreateMonitoredItemsRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getTimestampsToReturn() == that.getTimestampsToReturn() && this.getItemsToCreate() == that.getItemsToCreate() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getRequestHeader(), this.getSubscriptionId(), this.getTimestampsToReturn(), this.getItemsToCreate()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class CreateMonitoredItemsRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final long subscriptionId;
        private final TimestampsToReturn timestampsToReturn;
        private final List<MonitoredItemCreateRequest> itemsToCreate;

        public CreateMonitoredItemsRequestBuilderImpl(RequestHeader requestHeader, long subscriptionId, TimestampsToReturn timestampsToReturn, List<MonitoredItemCreateRequest> itemsToCreate) {
            this.requestHeader = requestHeader;
            this.subscriptionId = subscriptionId;
            this.timestampsToReturn = timestampsToReturn;
            this.itemsToCreate = itemsToCreate;
        }

        @Override
        public CreateMonitoredItemsRequest build() {
            CreateMonitoredItemsRequest createMonitoredItemsRequest = new CreateMonitoredItemsRequest(this.requestHeader, this.subscriptionId, this.timestampsToReturn, this.itemsToCreate);
            return createMonitoredItemsRequest;
        }
    }
}

