/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DatagramWriterGroupTransport2DataType
extends ExtensionObjectDefinition
implements Message {
    protected final short messageRepeatCount;
    protected final double messageRepeatDelay;
    protected final ExtensionObject address;
    protected final PascalString qosCategory;
    protected final List<ExtensionObject> datagramQos;
    protected final long discoveryAnnounceRate;
    protected final PascalString topic;

    @Override
    public Integer getExtensionId() {
        return 23615;
    }

    public DatagramWriterGroupTransport2DataType(short messageRepeatCount, double messageRepeatDelay, ExtensionObject address, PascalString qosCategory, List<ExtensionObject> datagramQos, long discoveryAnnounceRate, PascalString topic) {
        this.messageRepeatCount = messageRepeatCount;
        this.messageRepeatDelay = messageRepeatDelay;
        this.address = address;
        this.qosCategory = qosCategory;
        this.datagramQos = datagramQos;
        this.discoveryAnnounceRate = discoveryAnnounceRate;
        this.topic = topic;
    }

    public short getMessageRepeatCount() {
        return this.messageRepeatCount;
    }

    public double getMessageRepeatDelay() {
        return this.messageRepeatDelay;
    }

    public ExtensionObject getAddress() {
        return this.address;
    }

    public PascalString getQosCategory() {
        return this.qosCategory;
    }

    public List<ExtensionObject> getDatagramQos() {
        return this.datagramQos;
    }

    public long getDiscoveryAnnounceRate() {
        return this.discoveryAnnounceRate;
    }

    public PascalString getTopic() {
        return this.topic;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DatagramWriterGroupTransport2DataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageRepeatCount", (Object)this.messageRepeatCount, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageRepeatDelay", (Object)this.messageRepeatDelay, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"address", (Object)this.address, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"qosCategory", (Object)this.qosCategory, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDatagramQos = this.getDatagramQos() == null ? -1 : StaticHelper.COUNT(this.getDatagramQos());
        FieldWriterFactory.writeImplicitField((String)"noOfDatagramQos", (Object)noOfDatagramQos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"datagramQos", this.datagramQos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"discoveryAnnounceRate", (Object)this.discoveryAnnounceRate, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"topic", (Object)this.topic, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DatagramWriterGroupTransport2DataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DatagramWriterGroupTransport2DataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 8;
        lengthInBits += 64;
        lengthInBits += this.address.getLengthInBits();
        lengthInBits += this.qosCategory.getLengthInBits();
        lengthInBits += 32;
        if (this.datagramQos != null) {
            int i = 0;
            for (ExtensionObject element : this.datagramQos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.datagramQos.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += 32;
        return lengthInBits += this.topic.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DatagramWriterGroupTransport2DataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        short messageRepeatCount = (Short)FieldReaderFactory.readSimpleField((String)"messageRepeatCount", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        double messageRepeatDelay = (Double)FieldReaderFactory.readSimpleField((String)"messageRepeatDelay", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject address = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"address", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString qosCategory = (PascalString)FieldReaderFactory.readSimpleField((String)"qosCategory", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDatagramQos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDatagramQos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List datagramQos = FieldReaderFactory.readCountArrayField((String)"datagramQos", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfDatagramQos, (WithReaderArgs[])new WithReaderArgs[0]);
        long discoveryAnnounceRate = (Long)FieldReaderFactory.readSimpleField((String)"discoveryAnnounceRate", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString topic = (PascalString)FieldReaderFactory.readSimpleField((String)"topic", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DatagramWriterGroupTransport2DataType", new WithReaderArgs[0]);
        return new DatagramWriterGroupTransport2DataTypeBuilderImpl(messageRepeatCount, messageRepeatDelay, address, qosCategory, datagramQos, discoveryAnnounceRate, topic);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DatagramWriterGroupTransport2DataType)) {
            return false;
        }
        DatagramWriterGroupTransport2DataType that = (DatagramWriterGroupTransport2DataType)o;
        return this.getMessageRepeatCount() == that.getMessageRepeatCount() && this.getMessageRepeatDelay() == that.getMessageRepeatDelay() && this.getAddress() == that.getAddress() && this.getQosCategory() == that.getQosCategory() && this.getDatagramQos() == that.getDatagramQos() && this.getDiscoveryAnnounceRate() == that.getDiscoveryAnnounceRate() && this.getTopic() == that.getTopic() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageRepeatCount(), this.getMessageRepeatDelay(), this.getAddress(), this.getQosCategory(), this.getDatagramQos(), this.getDiscoveryAnnounceRate(), this.getTopic());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DatagramWriterGroupTransport2DataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final short messageRepeatCount;
        private final double messageRepeatDelay;
        private final ExtensionObject address;
        private final PascalString qosCategory;
        private final List<ExtensionObject> datagramQos;
        private final long discoveryAnnounceRate;
        private final PascalString topic;

        public DatagramWriterGroupTransport2DataTypeBuilderImpl(short messageRepeatCount, double messageRepeatDelay, ExtensionObject address, PascalString qosCategory, List<ExtensionObject> datagramQos, long discoveryAnnounceRate, PascalString topic) {
            this.messageRepeatCount = messageRepeatCount;
            this.messageRepeatDelay = messageRepeatDelay;
            this.address = address;
            this.qosCategory = qosCategory;
            this.datagramQos = datagramQos;
            this.discoveryAnnounceRate = discoveryAnnounceRate;
            this.topic = topic;
        }

        @Override
        public DatagramWriterGroupTransport2DataType build() {
            DatagramWriterGroupTransport2DataType datagramWriterGroupTransport2DataType = new DatagramWriterGroupTransport2DataType(this.messageRepeatCount, this.messageRepeatDelay, this.address, this.qosCategory, this.datagramQos, this.discoveryAnnounceRate, this.topic);
            return datagramWriterGroupTransport2DataType;
        }
    }
}

