/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DeleteReferencesItem;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DeleteReferencesRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<DeleteReferencesItem> referencesToDelete;

    @Override
    public Integer getExtensionId() {
        return 506;
    }

    public DeleteReferencesRequest(RequestHeader requestHeader, List<DeleteReferencesItem> referencesToDelete) {
        this.requestHeader = requestHeader;
        this.referencesToDelete = referencesToDelete;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<DeleteReferencesItem> getReferencesToDelete() {
        return this.referencesToDelete;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DeleteReferencesRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfReferencesToDelete = this.getReferencesToDelete() == null ? -1 : StaticHelper.COUNT(this.getReferencesToDelete());
        FieldWriterFactory.writeImplicitField((String)"noOfReferencesToDelete", (Object)noOfReferencesToDelete, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"referencesToDelete", this.referencesToDelete, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DeleteReferencesRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DeleteReferencesRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.referencesToDelete != null) {
            int i = 0;
            for (DeleteReferencesItem element : this.referencesToDelete) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.referencesToDelete.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DeleteReferencesRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfReferencesToDelete = (Integer)FieldReaderFactory.readImplicitField((String)"noOfReferencesToDelete", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List referencesToDelete = FieldReaderFactory.readCountArrayField((String)"referencesToDelete", (DataReader)DataReaderFactory.readComplex(() -> (DeleteReferencesItem)ExtensionObjectDefinition.staticParse(readBuffer, 387), (ReadBuffer)readBuffer), (long)noOfReferencesToDelete, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DeleteReferencesRequest", new WithReaderArgs[0]);
        return new DeleteReferencesRequestBuilderImpl(requestHeader, referencesToDelete);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteReferencesRequest)) {
            return false;
        }
        DeleteReferencesRequest that = (DeleteReferencesRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getReferencesToDelete() == that.getReferencesToDelete() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getReferencesToDelete());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DeleteReferencesRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<DeleteReferencesItem> referencesToDelete;

        public DeleteReferencesRequestBuilderImpl(RequestHeader requestHeader, List<DeleteReferencesItem> referencesToDelete) {
            this.requestHeader = requestHeader;
            this.referencesToDelete = referencesToDelete;
        }

        @Override
        public DeleteReferencesRequest build() {
            DeleteReferencesRequest deleteReferencesRequest = new DeleteReferencesRequest(this.requestHeader, this.referencesToDelete);
            return deleteReferencesRequest;
        }
    }
}

