/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class DtlsPubSubConnectionDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString clientCipherSuite;
    protected final List<PascalString> serverCipherSuites;
    protected final boolean zeroRTT;
    protected final NodeId certificateGroupId;
    protected final boolean verifyClientCertificate;

    @Override
    public Integer getExtensionId() {
        return 18796;
    }

    public DtlsPubSubConnectionDataType(PascalString clientCipherSuite, List<PascalString> serverCipherSuites, boolean zeroRTT, NodeId certificateGroupId, boolean verifyClientCertificate) {
        this.clientCipherSuite = clientCipherSuite;
        this.serverCipherSuites = serverCipherSuites;
        this.zeroRTT = zeroRTT;
        this.certificateGroupId = certificateGroupId;
        this.verifyClientCertificate = verifyClientCertificate;
    }

    public PascalString getClientCipherSuite() {
        return this.clientCipherSuite;
    }

    public List<PascalString> getServerCipherSuites() {
        return this.serverCipherSuites;
    }

    public boolean getZeroRTT() {
        return this.zeroRTT;
    }

    public NodeId getCertificateGroupId() {
        return this.certificateGroupId;
    }

    public boolean getVerifyClientCertificate() {
        return this.verifyClientCertificate;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("DtlsPubSubConnectionDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"clientCipherSuite", (Object)this.clientCipherSuite, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfServerCipherSuites = this.getServerCipherSuites() == null ? -1 : StaticHelper.COUNT(this.getServerCipherSuites());
        FieldWriterFactory.writeImplicitField((String)"noOfServerCipherSuites", (Object)noOfServerCipherSuites, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"serverCipherSuites", this.serverCipherSuites, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"zeroRTT", (Object)this.zeroRTT, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"certificateGroupId", (Object)this.certificateGroupId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"verifyClientCertificate", (Object)this.verifyClientCertificate, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("DtlsPubSubConnectionDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        DtlsPubSubConnectionDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.clientCipherSuite.getLengthInBits();
        lengthInBits += 32;
        if (this.serverCipherSuites != null) {
            int i = 0;
            for (PascalString element : this.serverCipherSuites) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.serverCipherSuites.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += this.certificateGroupId.getLengthInBits();
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("DtlsPubSubConnectionDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString clientCipherSuite = (PascalString)FieldReaderFactory.readSimpleField((String)"clientCipherSuite", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfServerCipherSuites = (Integer)FieldReaderFactory.readImplicitField((String)"noOfServerCipherSuites", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List serverCipherSuites = FieldReaderFactory.readCountArrayField((String)"serverCipherSuites", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfServerCipherSuites, (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean zeroRTT = (Boolean)FieldReaderFactory.readSimpleField((String)"zeroRTT", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId certificateGroupId = (NodeId)FieldReaderFactory.readSimpleField((String)"certificateGroupId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField1 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean verifyClientCertificate = (Boolean)FieldReaderFactory.readSimpleField((String)"verifyClientCertificate", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("DtlsPubSubConnectionDataType", new WithReaderArgs[0]);
        return new DtlsPubSubConnectionDataTypeBuilderImpl(clientCipherSuite, serverCipherSuites, zeroRTT, certificateGroupId, verifyClientCertificate);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DtlsPubSubConnectionDataType)) {
            return false;
        }
        DtlsPubSubConnectionDataType that = (DtlsPubSubConnectionDataType)o;
        return this.getClientCipherSuite() == that.getClientCipherSuite() && this.getServerCipherSuites() == that.getServerCipherSuites() && this.getZeroRTT() == that.getZeroRTT() && this.getCertificateGroupId() == that.getCertificateGroupId() && this.getVerifyClientCertificate() == that.getVerifyClientCertificate() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getClientCipherSuite(), this.getServerCipherSuites(), this.getZeroRTT(), this.getCertificateGroupId(), this.getVerifyClientCertificate());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class DtlsPubSubConnectionDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString clientCipherSuite;
        private final List<PascalString> serverCipherSuites;
        private final boolean zeroRTT;
        private final NodeId certificateGroupId;
        private final boolean verifyClientCertificate;

        public DtlsPubSubConnectionDataTypeBuilderImpl(PascalString clientCipherSuite, List<PascalString> serverCipherSuites, boolean zeroRTT, NodeId certificateGroupId, boolean verifyClientCertificate) {
            this.clientCipherSuite = clientCipherSuite;
            this.serverCipherSuites = serverCipherSuites;
            this.zeroRTT = zeroRTT;
            this.certificateGroupId = certificateGroupId;
            this.verifyClientCertificate = verifyClientCertificate;
        }

        @Override
        public DtlsPubSubConnectionDataType build() {
            DtlsPubSubConnectionDataType dtlsPubSubConnectionDataType = new DtlsPubSubConnectionDataType(this.clientCipherSuite, this.serverCipherSuites, this.zeroRTT, this.certificateGroupId, this.verifyClientCertificate);
            return dtlsPubSubConnectionDataType;
        }
    }
}

