/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ContentFilterResult;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class EventFilterResult
extends ExtensionObjectDefinition
implements Message {
    protected final List<StatusCode> selectClauseResults;
    protected final List<DiagnosticInfo> selectClauseDiagnosticInfos;
    protected final ContentFilterResult whereClauseResult;

    @Override
    public Integer getExtensionId() {
        return 736;
    }

    public EventFilterResult(List<StatusCode> selectClauseResults, List<DiagnosticInfo> selectClauseDiagnosticInfos, ContentFilterResult whereClauseResult) {
        this.selectClauseResults = selectClauseResults;
        this.selectClauseDiagnosticInfos = selectClauseDiagnosticInfos;
        this.whereClauseResult = whereClauseResult;
    }

    public List<StatusCode> getSelectClauseResults() {
        return this.selectClauseResults;
    }

    public List<DiagnosticInfo> getSelectClauseDiagnosticInfos() {
        return this.selectClauseDiagnosticInfos;
    }

    public ContentFilterResult getWhereClauseResult() {
        return this.whereClauseResult;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("EventFilterResult", new WithWriterArgs[0]);
        int noOfSelectClauseResults = this.getSelectClauseResults() == null ? -1 : StaticHelper.COUNT(this.getSelectClauseResults());
        FieldWriterFactory.writeImplicitField((String)"noOfSelectClauseResults", (Object)noOfSelectClauseResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"selectClauseResults", this.selectClauseResults, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSelectClauseDiagnosticInfos = this.getSelectClauseDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getSelectClauseDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfSelectClauseDiagnosticInfos", (Object)noOfSelectClauseDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"selectClauseDiagnosticInfos", this.selectClauseDiagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"whereClauseResult", (Object)this.whereClauseResult, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("EventFilterResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        EventFilterResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.selectClauseResults != null) {
            i = 0;
            for (StatusCode statusCode : this.selectClauseResults) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.selectClauseResults.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.selectClauseDiagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.selectClauseDiagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.selectClauseDiagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits += this.whereClauseResult.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("EventFilterResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfSelectClauseResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSelectClauseResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List selectClauseResults = FieldReaderFactory.readCountArrayField((String)"selectClauseResults", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfSelectClauseResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSelectClauseDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSelectClauseDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List selectClauseDiagnosticInfos = FieldReaderFactory.readCountArrayField((String)"selectClauseDiagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfSelectClauseDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        ContentFilterResult whereClauseResult = (ContentFilterResult)FieldReaderFactory.readSimpleField((String)"whereClauseResult", (DataReader)DataReaderFactory.readComplex(() -> (ContentFilterResult)ExtensionObjectDefinition.staticParse(readBuffer, 609), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("EventFilterResult", new WithReaderArgs[0]);
        return new EventFilterResultBuilderImpl(selectClauseResults, selectClauseDiagnosticInfos, whereClauseResult);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventFilterResult)) {
            return false;
        }
        EventFilterResult that = (EventFilterResult)o;
        return this.getSelectClauseResults() == that.getSelectClauseResults() && this.getSelectClauseDiagnosticInfos() == that.getSelectClauseDiagnosticInfos() && this.getWhereClauseResult() == that.getWhereClauseResult() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSelectClauseResults(), this.getSelectClauseDiagnosticInfos(), this.getWhereClauseResult());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class EventFilterResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<StatusCode> selectClauseResults;
        private final List<DiagnosticInfo> selectClauseDiagnosticInfos;
        private final ContentFilterResult whereClauseResult;

        public EventFilterResultBuilderImpl(List<StatusCode> selectClauseResults, List<DiagnosticInfo> selectClauseDiagnosticInfos, ContentFilterResult whereClauseResult) {
            this.selectClauseResults = selectClauseResults;
            this.selectClauseDiagnosticInfos = selectClauseDiagnosticInfos;
            this.whereClauseResult = whereClauseResult;
        }

        @Override
        public EventFilterResult build() {
            EventFilterResult eventFilterResult = new EventFilterResult(this.selectClauseResults, this.selectClauseDiagnosticInfos, this.whereClauseResult);
            return eventFilterResult;
        }
    }
}

