/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.GenericAttributeValue;
import org.apache.plc4x.java.opcua.readwrite.LocalizedText;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class GenericAttributes
extends ExtensionObjectDefinition
implements Message {
    protected final long specifiedAttributes;
    protected final LocalizedText displayName;
    protected final LocalizedText description;
    protected final long writeMask;
    protected final long userWriteMask;
    protected final List<GenericAttributeValue> attributeValues;

    @Override
    public Integer getExtensionId() {
        return 17609;
    }

    public GenericAttributes(long specifiedAttributes, LocalizedText displayName, LocalizedText description, long writeMask, long userWriteMask, List<GenericAttributeValue> attributeValues) {
        this.specifiedAttributes = specifiedAttributes;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
        this.attributeValues = attributeValues;
    }

    public long getSpecifiedAttributes() {
        return this.specifiedAttributes;
    }

    public LocalizedText getDisplayName() {
        return this.displayName;
    }

    public LocalizedText getDescription() {
        return this.description;
    }

    public long getWriteMask() {
        return this.writeMask;
    }

    public long getUserWriteMask() {
        return this.userWriteMask;
    }

    public List<GenericAttributeValue> getAttributeValues() {
        return this.attributeValues;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("GenericAttributes", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"specifiedAttributes", (Object)this.specifiedAttributes, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"displayName", (Object)this.displayName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writeMask", (Object)this.writeMask, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"userWriteMask", (Object)this.userWriteMask, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAttributeValues = this.getAttributeValues() == null ? -1 : StaticHelper.COUNT(this.getAttributeValues());
        FieldWriterFactory.writeImplicitField((String)"noOfAttributeValues", (Object)noOfAttributeValues, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"attributeValues", this.attributeValues, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("GenericAttributes", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        GenericAttributes _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.displayName.getLengthInBits();
        lengthInBits += this.description.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.attributeValues != null) {
            int i = 0;
            for (GenericAttributeValue element : this.attributeValues) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.attributeValues.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("GenericAttributes", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long specifiedAttributes = (Long)FieldReaderFactory.readSimpleField((String)"specifiedAttributes", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText displayName = (LocalizedText)FieldReaderFactory.readSimpleField((String)"displayName", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        LocalizedText description = (LocalizedText)FieldReaderFactory.readSimpleField((String)"description", (DataReader)DataReaderFactory.readComplex(() -> LocalizedText.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long writeMask = (Long)FieldReaderFactory.readSimpleField((String)"writeMask", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long userWriteMask = (Long)FieldReaderFactory.readSimpleField((String)"userWriteMask", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAttributeValues = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAttributeValues", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List attributeValues = FieldReaderFactory.readCountArrayField((String)"attributeValues", (DataReader)DataReaderFactory.readComplex(() -> (GenericAttributeValue)ExtensionObjectDefinition.staticParse(readBuffer, 17608), (ReadBuffer)readBuffer), (long)noOfAttributeValues, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("GenericAttributes", new WithReaderArgs[0]);
        return new GenericAttributesBuilderImpl(specifiedAttributes, displayName, description, writeMask, userWriteMask, attributeValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericAttributes)) {
            return false;
        }
        GenericAttributes that = (GenericAttributes)o;
        return this.getSpecifiedAttributes() == that.getSpecifiedAttributes() && this.getDisplayName() == that.getDisplayName() && this.getDescription() == that.getDescription() && this.getWriteMask() == that.getWriteMask() && this.getUserWriteMask() == that.getUserWriteMask() && this.getAttributeValues() == that.getAttributeValues() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSpecifiedAttributes(), this.getDisplayName(), this.getDescription(), this.getWriteMask(), this.getUserWriteMask(), this.getAttributeValues());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class GenericAttributesBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long specifiedAttributes;
        private final LocalizedText displayName;
        private final LocalizedText description;
        private final long writeMask;
        private final long userWriteMask;
        private final List<GenericAttributeValue> attributeValues;

        public GenericAttributesBuilderImpl(long specifiedAttributes, LocalizedText displayName, LocalizedText description, long writeMask, long userWriteMask, List<GenericAttributeValue> attributeValues) {
            this.specifiedAttributes = specifiedAttributes;
            this.displayName = displayName;
            this.description = description;
            this.writeMask = writeMask;
            this.userWriteMask = userWriteMask;
            this.attributeValues = attributeValues;
        }

        @Override
        public GenericAttributes build() {
            GenericAttributes genericAttributes = new GenericAttributes(this.specifiedAttributes, this.displayName, this.description, this.writeMask, this.userWriteMask, this.attributeValues);
            return genericAttributes;
        }
    }
}

