/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.HistoryEventFieldList;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryEvent
extends ExtensionObjectDefinition
implements Message {
    protected final List<HistoryEventFieldList> events;

    @Override
    public Integer getExtensionId() {
        return 661;
    }

    public HistoryEvent(List<HistoryEventFieldList> events) {
        this.events = events;
    }

    public List<HistoryEventFieldList> getEvents() {
        return this.events;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryEvent", new WithWriterArgs[0]);
        int noOfEvents = this.getEvents() == null ? -1 : StaticHelper.COUNT(this.getEvents());
        FieldWriterFactory.writeImplicitField((String)"noOfEvents", (Object)noOfEvents, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"events", this.events, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryEvent", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryEvent _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.events != null) {
            int i = 0;
            for (HistoryEventFieldList element : this.events) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.events.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryEvent", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfEvents = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEvents", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List events = FieldReaderFactory.readCountArrayField((String)"events", (DataReader)DataReaderFactory.readComplex(() -> (HistoryEventFieldList)ExtensionObjectDefinition.staticParse(readBuffer, 922), (ReadBuffer)readBuffer), (long)noOfEvents, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryEvent", new WithReaderArgs[0]);
        return new HistoryEventBuilderImpl(events);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryEvent)) {
            return false;
        }
        HistoryEvent that = (HistoryEvent)o;
        return this.getEvents() == that.getEvents() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEvents());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryEventBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<HistoryEventFieldList> events;

        public HistoryEventBuilderImpl(List<HistoryEventFieldList> events) {
            this.events = events;
        }

        @Override
        public HistoryEvent build() {
            HistoryEvent historyEvent = new HistoryEvent(this.events);
            return historyEvent;
        }
    }
}

