/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.HistoryEventFieldList;
import org.apache.plc4x.java.opcua.readwrite.ModificationInfo;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryModifiedEvent
extends ExtensionObjectDefinition
implements Message {
    protected final List<HistoryEventFieldList> events;
    protected final List<ModificationInfo> modificationInfos;

    @Override
    public Integer getExtensionId() {
        return 32826;
    }

    public HistoryModifiedEvent(List<HistoryEventFieldList> events, List<ModificationInfo> modificationInfos) {
        this.events = events;
        this.modificationInfos = modificationInfos;
    }

    public List<HistoryEventFieldList> getEvents() {
        return this.events;
    }

    public List<ModificationInfo> getModificationInfos() {
        return this.modificationInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryModifiedEvent", new WithWriterArgs[0]);
        int noOfEvents = this.getEvents() == null ? -1 : StaticHelper.COUNT(this.getEvents());
        FieldWriterFactory.writeImplicitField((String)"noOfEvents", (Object)noOfEvents, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"events", this.events, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfModificationInfos = this.getModificationInfos() == null ? -1 : StaticHelper.COUNT(this.getModificationInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfModificationInfos", (Object)noOfModificationInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"modificationInfos", this.modificationInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryModifiedEvent", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        HistoryModifiedEvent _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.events != null) {
            i = 0;
            for (HistoryEventFieldList historyEventFieldList : this.events) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.events.size());
                lengthInBits += historyEventFieldList.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.modificationInfos != null) {
            i = 0;
            for (ModificationInfo modificationInfo : this.modificationInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.modificationInfos.size());
                lengthInBits += modificationInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryModifiedEvent", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfEvents = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEvents", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List events = FieldReaderFactory.readCountArrayField((String)"events", (DataReader)DataReaderFactory.readComplex(() -> (HistoryEventFieldList)ExtensionObjectDefinition.staticParse(readBuffer, 922), (ReadBuffer)readBuffer), (long)noOfEvents, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfModificationInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfModificationInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List modificationInfos = FieldReaderFactory.readCountArrayField((String)"modificationInfos", (DataReader)DataReaderFactory.readComplex(() -> (ModificationInfo)ExtensionObjectDefinition.staticParse(readBuffer, 11218), (ReadBuffer)readBuffer), (long)noOfModificationInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryModifiedEvent", new WithReaderArgs[0]);
        return new HistoryModifiedEventBuilderImpl(events, modificationInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryModifiedEvent)) {
            return false;
        }
        HistoryModifiedEvent that = (HistoryModifiedEvent)o;
        return this.getEvents() == that.getEvents() && this.getModificationInfos() == that.getModificationInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getEvents(), this.getModificationInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryModifiedEventBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<HistoryEventFieldList> events;
        private final List<ModificationInfo> modificationInfos;

        public HistoryModifiedEventBuilderImpl(List<HistoryEventFieldList> events, List<ModificationInfo> modificationInfos) {
            this.events = events;
            this.modificationInfos = modificationInfos;
        }

        @Override
        public HistoryModifiedEvent build() {
            HistoryModifiedEvent historyModifiedEvent = new HistoryModifiedEvent(this.events, this.modificationInfos);
            return historyModifiedEvent;
        }
    }
}

