/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class HistoryUpdateRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final List<ExtensionObject> historyUpdateDetails;

    @Override
    public Integer getExtensionId() {
        return 700;
    }

    public HistoryUpdateRequest(RequestHeader requestHeader, List<ExtensionObject> historyUpdateDetails) {
        this.requestHeader = requestHeader;
        this.historyUpdateDetails = historyUpdateDetails;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public List<ExtensionObject> getHistoryUpdateDetails() {
        return this.historyUpdateDetails;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("HistoryUpdateRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfHistoryUpdateDetails = this.getHistoryUpdateDetails() == null ? -1 : StaticHelper.COUNT(this.getHistoryUpdateDetails());
        FieldWriterFactory.writeImplicitField((String)"noOfHistoryUpdateDetails", (Object)noOfHistoryUpdateDetails, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"historyUpdateDetails", this.historyUpdateDetails, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("HistoryUpdateRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        HistoryUpdateRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.historyUpdateDetails != null) {
            int i = 0;
            for (ExtensionObject element : this.historyUpdateDetails) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.historyUpdateDetails.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("HistoryUpdateRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfHistoryUpdateDetails = (Integer)FieldReaderFactory.readImplicitField((String)"noOfHistoryUpdateDetails", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List historyUpdateDetails = FieldReaderFactory.readCountArrayField((String)"historyUpdateDetails", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (long)noOfHistoryUpdateDetails, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("HistoryUpdateRequest", new WithReaderArgs[0]);
        return new HistoryUpdateRequestBuilderImpl(requestHeader, historyUpdateDetails);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HistoryUpdateRequest)) {
            return false;
        }
        HistoryUpdateRequest that = (HistoryUpdateRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getHistoryUpdateDetails() == that.getHistoryUpdateDetails() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getHistoryUpdateDetails());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class HistoryUpdateRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final List<ExtensionObject> historyUpdateDetails;

        public HistoryUpdateRequestBuilderImpl(RequestHeader requestHeader, List<ExtensionObject> historyUpdateDetails) {
            this.requestHeader = requestHeader;
            this.historyUpdateDetails = historyUpdateDetails;
        }

        @Override
        public HistoryUpdateRequest build() {
            HistoryUpdateRequest historyUpdateRequest = new HistoryUpdateRequest(this.requestHeader, this.historyUpdateDetails);
            return historyUpdateRequest;
        }
    }
}

