/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class JsonApplicationDescriptionMessage
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString messageId;
    protected final PascalString messageType;
    protected final PascalString publisherId;
    protected final long timestamp;
    protected final ApplicationDescription description;
    protected final List<PascalString> serverCapabilities;

    @Override
    public Integer getExtensionId() {
        return 19316;
    }

    public JsonApplicationDescriptionMessage(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, ApplicationDescription description, List<PascalString> serverCapabilities) {
        this.messageId = messageId;
        this.messageType = messageType;
        this.publisherId = publisherId;
        this.timestamp = timestamp;
        this.description = description;
        this.serverCapabilities = serverCapabilities;
    }

    public PascalString getMessageId() {
        return this.messageId;
    }

    public PascalString getMessageType() {
        return this.messageType;
    }

    public PascalString getPublisherId() {
        return this.publisherId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ApplicationDescription getDescription() {
        return this.description;
    }

    public List<PascalString> getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("JsonApplicationDescriptionMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageId", (Object)this.messageId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageType", (Object)this.messageType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfServerCapabilities = this.getServerCapabilities() == null ? -1 : StaticHelper.COUNT(this.getServerCapabilities());
        FieldWriterFactory.writeImplicitField((String)"noOfServerCapabilities", (Object)noOfServerCapabilities, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"serverCapabilities", this.serverCapabilities, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("JsonApplicationDescriptionMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        JsonApplicationDescriptionMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.messageId.getLengthInBits();
        lengthInBits += this.messageType.getLengthInBits();
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += this.description.getLengthInBits();
        lengthInBits += 32;
        if (this.serverCapabilities != null) {
            int i = 0;
            for (PascalString element : this.serverCapabilities) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.serverCapabilities.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("JsonApplicationDescriptionMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString messageId = (PascalString)FieldReaderFactory.readSimpleField((String)"messageId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString messageType = (PascalString)FieldReaderFactory.readSimpleField((String)"messageType", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString publisherId = (PascalString)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long timestamp = (Long)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        ApplicationDescription description = (ApplicationDescription)FieldReaderFactory.readSimpleField((String)"description", (DataReader)DataReaderFactory.readComplex(() -> (ApplicationDescription)ExtensionObjectDefinition.staticParse(readBuffer, 310), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfServerCapabilities = (Integer)FieldReaderFactory.readImplicitField((String)"noOfServerCapabilities", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List serverCapabilities = FieldReaderFactory.readCountArrayField((String)"serverCapabilities", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfServerCapabilities, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("JsonApplicationDescriptionMessage", new WithReaderArgs[0]);
        return new JsonApplicationDescriptionMessageBuilderImpl(messageId, messageType, publisherId, timestamp, description, serverCapabilities);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonApplicationDescriptionMessage)) {
            return false;
        }
        JsonApplicationDescriptionMessage that = (JsonApplicationDescriptionMessage)o;
        return this.getMessageId() == that.getMessageId() && this.getMessageType() == that.getMessageType() && this.getPublisherId() == that.getPublisherId() && this.getTimestamp() == that.getTimestamp() && this.getDescription() == that.getDescription() && this.getServerCapabilities() == that.getServerCapabilities() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageId(), this.getMessageType(), this.getPublisherId(), this.getTimestamp(), this.getDescription(), this.getServerCapabilities());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class JsonApplicationDescriptionMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString messageId;
        private final PascalString messageType;
        private final PascalString publisherId;
        private final long timestamp;
        private final ApplicationDescription description;
        private final List<PascalString> serverCapabilities;

        public JsonApplicationDescriptionMessageBuilderImpl(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, ApplicationDescription description, List<PascalString> serverCapabilities) {
            this.messageId = messageId;
            this.messageType = messageType;
            this.publisherId = publisherId;
            this.timestamp = timestamp;
            this.description = description;
            this.serverCapabilities = serverCapabilities;
        }

        @Override
        public JsonApplicationDescriptionMessage build() {
            JsonApplicationDescriptionMessage jsonApplicationDescriptionMessage = new JsonApplicationDescriptionMessage(this.messageId, this.messageType, this.publisherId, this.timestamp, this.description, this.serverCapabilities);
            return jsonApplicationDescriptionMessage;
        }
    }
}

