/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ApplicationDescription;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class JsonServerEndpointsMessage
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString messageId;
    protected final PascalString messageType;
    protected final PascalString publisherId;
    protected final long timestamp;
    protected final ApplicationDescription description;
    protected final List<EndpointDescription> endpoints;

    @Override
    public Integer getExtensionId() {
        return 19317;
    }

    public JsonServerEndpointsMessage(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, ApplicationDescription description, List<EndpointDescription> endpoints) {
        this.messageId = messageId;
        this.messageType = messageType;
        this.publisherId = publisherId;
        this.timestamp = timestamp;
        this.description = description;
        this.endpoints = endpoints;
    }

    public PascalString getMessageId() {
        return this.messageId;
    }

    public PascalString getMessageType() {
        return this.messageType;
    }

    public PascalString getPublisherId() {
        return this.publisherId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ApplicationDescription getDescription() {
        return this.description;
    }

    public List<EndpointDescription> getEndpoints() {
        return this.endpoints;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("JsonServerEndpointsMessage", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageId", (Object)this.messageId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageType", (Object)this.messageType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publisherId", (Object)this.publisherId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"timestamp", (Object)this.timestamp, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"description", (Object)this.description, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfEndpoints = this.getEndpoints() == null ? -1 : StaticHelper.COUNT(this.getEndpoints());
        FieldWriterFactory.writeImplicitField((String)"noOfEndpoints", (Object)noOfEndpoints, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"endpoints", this.endpoints, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("JsonServerEndpointsMessage", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        JsonServerEndpointsMessage _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.messageId.getLengthInBits();
        lengthInBits += this.messageType.getLengthInBits();
        lengthInBits += this.publisherId.getLengthInBits();
        lengthInBits += 64;
        lengthInBits += this.description.getLengthInBits();
        lengthInBits += 32;
        if (this.endpoints != null) {
            int i = 0;
            for (EndpointDescription element : this.endpoints) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.endpoints.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("JsonServerEndpointsMessage", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString messageId = (PascalString)FieldReaderFactory.readSimpleField((String)"messageId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString messageType = (PascalString)FieldReaderFactory.readSimpleField((String)"messageType", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString publisherId = (PascalString)FieldReaderFactory.readSimpleField((String)"publisherId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long timestamp = (Long)FieldReaderFactory.readSimpleField((String)"timestamp", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        ApplicationDescription description = (ApplicationDescription)FieldReaderFactory.readSimpleField((String)"description", (DataReader)DataReaderFactory.readComplex(() -> (ApplicationDescription)ExtensionObjectDefinition.staticParse(readBuffer, 310), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfEndpoints = (Integer)FieldReaderFactory.readImplicitField((String)"noOfEndpoints", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List endpoints = FieldReaderFactory.readCountArrayField((String)"endpoints", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfEndpoints, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("JsonServerEndpointsMessage", new WithReaderArgs[0]);
        return new JsonServerEndpointsMessageBuilderImpl(messageId, messageType, publisherId, timestamp, description, endpoints);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonServerEndpointsMessage)) {
            return false;
        }
        JsonServerEndpointsMessage that = (JsonServerEndpointsMessage)o;
        return this.getMessageId() == that.getMessageId() && this.getMessageType() == that.getMessageType() && this.getPublisherId() == that.getPublisherId() && this.getTimestamp() == that.getTimestamp() && this.getDescription() == that.getDescription() && this.getEndpoints() == that.getEndpoints() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMessageId(), this.getMessageType(), this.getPublisherId(), this.getTimestamp(), this.getDescription(), this.getEndpoints());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class JsonServerEndpointsMessageBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString messageId;
        private final PascalString messageType;
        private final PascalString publisherId;
        private final long timestamp;
        private final ApplicationDescription description;
        private final List<EndpointDescription> endpoints;

        public JsonServerEndpointsMessageBuilderImpl(PascalString messageId, PascalString messageType, PascalString publisherId, long timestamp, ApplicationDescription description, List<EndpointDescription> endpoints) {
            this.messageId = messageId;
            this.messageType = messageType;
            this.publisherId = publisherId;
            this.timestamp = timestamp;
            this.description = description;
            this.endpoints = endpoints;
        }

        @Override
        public JsonServerEndpointsMessage build() {
            JsonServerEndpointsMessage jsonServerEndpointsMessage = new JsonServerEndpointsMessage(this.messageId, this.messageType, this.publisherId, this.timestamp, this.description, this.endpoints);
            return jsonServerEndpointsMessage;
        }
    }
}

