/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.EndpointUrlListDataType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NetworkGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString serverUri;
    protected final List<EndpointUrlListDataType> networkPaths;

    @Override
    public Integer getExtensionId() {
        return 11946;
    }

    public NetworkGroupDataType(PascalString serverUri, List<EndpointUrlListDataType> networkPaths) {
        this.serverUri = serverUri;
        this.networkPaths = networkPaths;
    }

    public PascalString getServerUri() {
        return this.serverUri;
    }

    public List<EndpointUrlListDataType> getNetworkPaths() {
        return this.networkPaths;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NetworkGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"serverUri", (Object)this.serverUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNetworkPaths = this.getNetworkPaths() == null ? -1 : StaticHelper.COUNT(this.getNetworkPaths());
        FieldWriterFactory.writeImplicitField((String)"noOfNetworkPaths", (Object)noOfNetworkPaths, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"networkPaths", this.networkPaths, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NetworkGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NetworkGroupDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.serverUri.getLengthInBits();
        lengthInBits += 32;
        if (this.networkPaths != null) {
            int i = 0;
            for (EndpointUrlListDataType element : this.networkPaths) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.networkPaths.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("NetworkGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString serverUri = (PascalString)FieldReaderFactory.readSimpleField((String)"serverUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNetworkPaths = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNetworkPaths", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List networkPaths = FieldReaderFactory.readCountArrayField((String)"networkPaths", (DataReader)DataReaderFactory.readComplex(() -> (EndpointUrlListDataType)ExtensionObjectDefinition.staticParse(readBuffer, 11945), (ReadBuffer)readBuffer), (long)noOfNetworkPaths, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NetworkGroupDataType", new WithReaderArgs[0]);
        return new NetworkGroupDataTypeBuilderImpl(serverUri, networkPaths);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NetworkGroupDataType)) {
            return false;
        }
        NetworkGroupDataType that = (NetworkGroupDataType)o;
        return this.getServerUri() == that.getServerUri() && this.getNetworkPaths() == that.getNetworkPaths() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getServerUri(), this.getNetworkPaths());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NetworkGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString serverUri;
        private final List<EndpointUrlListDataType> networkPaths;

        public NetworkGroupDataTypeBuilderImpl(PascalString serverUri, List<EndpointUrlListDataType> networkPaths) {
            this.serverUri = serverUri;
            this.networkPaths = networkPaths;
        }

        @Override
        public NetworkGroupDataType build() {
            NetworkGroupDataType networkGroupDataType = new NetworkGroupDataType(this.serverUri, this.networkPaths);
            return networkGroupDataType;
        }
    }
}

