/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class NodeReference
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId nodeId;
    protected final NodeId referenceTypeId;
    protected final boolean isForward;
    protected final List<NodeId> referencedNodeIds;

    @Override
    public Integer getExtensionId() {
        return 582;
    }

    public NodeReference(NodeId nodeId, NodeId referenceTypeId, boolean isForward, List<NodeId> referencedNodeIds) {
        this.nodeId = nodeId;
        this.referenceTypeId = referenceTypeId;
        this.isForward = isForward;
        this.referencedNodeIds = referencedNodeIds;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeId getReferenceTypeId() {
        return this.referenceTypeId;
    }

    public boolean getIsForward() {
        return this.isForward;
    }

    public List<NodeId> getReferencedNodeIds() {
        return this.referencedNodeIds;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("NodeReference", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"nodeId", (Object)this.nodeId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"referenceTypeId", (Object)this.referenceTypeId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"isForward", (Object)this.isForward, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfReferencedNodeIds = this.getReferencedNodeIds() == null ? -1 : StaticHelper.COUNT(this.getReferencedNodeIds());
        FieldWriterFactory.writeImplicitField((String)"noOfReferencedNodeIds", (Object)noOfReferencedNodeIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"referencedNodeIds", this.referencedNodeIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("NodeReference", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        NodeReference _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.nodeId.getLengthInBits();
        lengthInBits += this.referenceTypeId.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        if (this.referencedNodeIds != null) {
            int i = 0;
            for (NodeId element : this.referencedNodeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.referencedNodeIds.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("NodeReference", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId nodeId = (NodeId)FieldReaderFactory.readSimpleField((String)"nodeId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId referenceTypeId = (NodeId)FieldReaderFactory.readSimpleField((String)"referenceTypeId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean isForward = (Boolean)FieldReaderFactory.readSimpleField((String)"isForward", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfReferencedNodeIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfReferencedNodeIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List referencedNodeIds = FieldReaderFactory.readCountArrayField((String)"referencedNodeIds", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfReferencedNodeIds, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("NodeReference", new WithReaderArgs[0]);
        return new NodeReferenceBuilderImpl(nodeId, referenceTypeId, isForward, referencedNodeIds);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodeReference)) {
            return false;
        }
        NodeReference that = (NodeReference)o;
        return this.getNodeId() == that.getNodeId() && this.getReferenceTypeId() == that.getReferenceTypeId() && this.getIsForward() == that.getIsForward() && this.getReferencedNodeIds() == that.getReferencedNodeIds() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNodeId(), this.getReferenceTypeId(), this.getIsForward(), this.getReferencedNodeIds());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class NodeReferenceBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId nodeId;
        private final NodeId referenceTypeId;
        private final boolean isForward;
        private final List<NodeId> referencedNodeIds;

        public NodeReferenceBuilderImpl(NodeId nodeId, NodeId referenceTypeId, boolean isForward, List<NodeId> referencedNodeIds) {
            this.nodeId = nodeId;
            this.referenceTypeId = referenceTypeId;
            this.isForward = isForward;
            this.referencedNodeIds = referencedNodeIds;
        }

        @Override
        public NodeReference build() {
            NodeReference nodeReference = new NodeReference(this.nodeId, this.referenceTypeId, this.isForward, this.referencedNodeIds);
            return nodeReference;
        }
    }
}

