/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ChunkType;
import org.apache.plc4x.java.opcua.readwrite.MessagePDU;
import org.apache.plc4x.java.opcua.readwrite.OpcuaProtocolLimits;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class OpcuaHelloRequest
extends MessagePDU
implements Message {
    protected final long version;
    protected final OpcuaProtocolLimits limits;
    protected final PascalString endpoint;

    @Override
    public String getMessageType() {
        return "HEL";
    }

    @Override
    public Boolean getResponse() {
        return false;
    }

    public OpcuaHelloRequest(ChunkType chunk, long version, OpcuaProtocolLimits limits, PascalString endpoint) {
        super(chunk);
        this.version = version;
        this.limits = limits;
        this.endpoint = endpoint;
    }

    public long getVersion() {
        return this.version;
    }

    public OpcuaProtocolLimits getLimits() {
        return this.limits;
    }

    public PascalString getEndpoint() {
        return this.endpoint;
    }

    @Override
    protected void serializeMessagePDUChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("OpcuaHelloRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"version", (Object)this.version, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"limits", (Object)this.limits, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endpoint", (Object)this.endpoint, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("OpcuaHelloRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        OpcuaHelloRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += this.limits.getLengthInBits();
        return lengthInBits += this.endpoint.getLengthInBits();
    }

    public static MessagePDU.MessagePDUBuilder staticParseMessagePDUBuilder(ReadBuffer readBuffer, Boolean response, Boolean binary) throws ParseException {
        readBuffer.pullContext("OpcuaHelloRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long version = (Long)FieldReaderFactory.readSimpleField((String)"version", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        OpcuaProtocolLimits limits = (OpcuaProtocolLimits)FieldReaderFactory.readSimpleField((String)"limits", (DataReader)DataReaderFactory.readComplex(() -> OpcuaProtocolLimits.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString endpoint = (PascalString)FieldReaderFactory.readSimpleField((String)"endpoint", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("OpcuaHelloRequest", new WithReaderArgs[0]);
        return new OpcuaHelloRequestBuilderImpl(version, limits, endpoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpcuaHelloRequest)) {
            return false;
        }
        OpcuaHelloRequest that = (OpcuaHelloRequest)o;
        return this.getVersion() == that.getVersion() && this.getLimits() == that.getLimits() && this.getEndpoint() == that.getEndpoint() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getVersion(), this.getLimits(), this.getEndpoint());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class OpcuaHelloRequestBuilderImpl
    implements MessagePDU.MessagePDUBuilder {
        private final long version;
        private final OpcuaProtocolLimits limits;
        private final PascalString endpoint;

        public OpcuaHelloRequestBuilderImpl(long version, OpcuaProtocolLimits limits, PascalString endpoint) {
            this.version = version;
            this.limits = limits;
            this.endpoint = endpoint;
        }

        @Override
        public OpcuaHelloRequest build(ChunkType chunk) {
            OpcuaHelloRequest opcuaHelloRequest = new OpcuaHelloRequest(chunk, this.version, this.limits, this.endpoint);
            return opcuaHelloRequest;
        }
    }
}

