/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PubSubConnectionDataType;
import org.apache.plc4x.java.opcua.readwrite.PublishedDataSetDataType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PubSubConfigurationDataType
extends ExtensionObjectDefinition
implements Message {
    protected final List<PublishedDataSetDataType> publishedDataSets;
    protected final List<PubSubConnectionDataType> connections;
    protected final boolean enabled;

    @Override
    public Integer getExtensionId() {
        return 15532;
    }

    public PubSubConfigurationDataType(List<PublishedDataSetDataType> publishedDataSets, List<PubSubConnectionDataType> connections, boolean enabled) {
        this.publishedDataSets = publishedDataSets;
        this.connections = connections;
        this.enabled = enabled;
    }

    public List<PublishedDataSetDataType> getPublishedDataSets() {
        return this.publishedDataSets;
    }

    public List<PubSubConnectionDataType> getConnections() {
        return this.connections;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PubSubConfigurationDataType", new WithWriterArgs[0]);
        int noOfPublishedDataSets = this.getPublishedDataSets() == null ? -1 : StaticHelper.COUNT(this.getPublishedDataSets());
        FieldWriterFactory.writeImplicitField((String)"noOfPublishedDataSets", (Object)noOfPublishedDataSets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"publishedDataSets", this.publishedDataSets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfConnections = this.getConnections() == null ? -1 : StaticHelper.COUNT(this.getConnections());
        FieldWriterFactory.writeImplicitField((String)"noOfConnections", (Object)noOfConnections, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"connections", this.connections, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"enabled", (Object)this.enabled, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PubSubConfigurationDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        PubSubConfigurationDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        if (this.publishedDataSets != null) {
            i = 0;
            for (PublishedDataSetDataType publishedDataSetDataType : this.publishedDataSets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.publishedDataSets.size());
                lengthInBits += publishedDataSetDataType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.connections != null) {
            i = 0;
            for (PubSubConnectionDataType pubSubConnectionDataType : this.connections) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.connections.size());
                lengthInBits += pubSubConnectionDataType.getLengthInBits();
            }
        }
        lengthInBits += 7;
        return ++lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PubSubConfigurationDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        int noOfPublishedDataSets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfPublishedDataSets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List publishedDataSets = FieldReaderFactory.readCountArrayField((String)"publishedDataSets", (DataReader)DataReaderFactory.readComplex(() -> (PublishedDataSetDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15580), (ReadBuffer)readBuffer), (long)noOfPublishedDataSets, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfConnections = (Integer)FieldReaderFactory.readImplicitField((String)"noOfConnections", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List connections = FieldReaderFactory.readCountArrayField((String)"connections", (DataReader)DataReaderFactory.readComplex(() -> (PubSubConnectionDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15619), (ReadBuffer)readBuffer), (long)noOfConnections, (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean enabled = (Boolean)FieldReaderFactory.readSimpleField((String)"enabled", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PubSubConfigurationDataType", new WithReaderArgs[0]);
        return new PubSubConfigurationDataTypeBuilderImpl(publishedDataSets, connections, enabled);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PubSubConfigurationDataType)) {
            return false;
        }
        PubSubConfigurationDataType that = (PubSubConfigurationDataType)o;
        return this.getPublishedDataSets() == that.getPublishedDataSets() && this.getConnections() == that.getConnections() && this.getEnabled() == that.getEnabled() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPublishedDataSets(), this.getConnections(), this.getEnabled());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PubSubConfigurationDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final List<PublishedDataSetDataType> publishedDataSets;
        private final List<PubSubConnectionDataType> connections;
        private final boolean enabled;

        public PubSubConfigurationDataTypeBuilderImpl(List<PublishedDataSetDataType> publishedDataSets, List<PubSubConnectionDataType> connections, boolean enabled) {
            this.publishedDataSets = publishedDataSets;
            this.connections = connections;
            this.enabled = enabled;
        }

        @Override
        public PubSubConfigurationDataType build() {
            PubSubConfigurationDataType pubSubConfigurationDataType = new PubSubConfigurationDataType(this.publishedDataSets, this.connections, this.enabled);
            return pubSubConfigurationDataType;
        }
    }
}

