/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DiagnosticInfo;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NotificationMessage;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PublishResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final long subscriptionId;
    protected final List<Long> availableSequenceNumbers;
    protected final boolean moreNotifications;
    protected final NotificationMessage notificationMessage;
    protected final List<StatusCode> results;
    protected final List<DiagnosticInfo> diagnosticInfos;

    @Override
    public Integer getExtensionId() {
        return 829;
    }

    public PublishResponse(ResponseHeader responseHeader, long subscriptionId, List<Long> availableSequenceNumbers, boolean moreNotifications, NotificationMessage notificationMessage, List<StatusCode> results, List<DiagnosticInfo> diagnosticInfos) {
        this.responseHeader = responseHeader;
        this.subscriptionId = subscriptionId;
        this.availableSequenceNumbers = availableSequenceNumbers;
        this.moreNotifications = moreNotifications;
        this.notificationMessage = notificationMessage;
        this.results = results;
        this.diagnosticInfos = diagnosticInfos;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public List<Long> getAvailableSequenceNumbers() {
        return this.availableSequenceNumbers;
    }

    public boolean getMoreNotifications() {
        return this.moreNotifications;
    }

    public NotificationMessage getNotificationMessage() {
        return this.notificationMessage;
    }

    public List<StatusCode> getResults() {
        return this.results;
    }

    public List<DiagnosticInfo> getDiagnosticInfos() {
        return this.diagnosticInfos;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PublishResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"subscriptionId", (Object)this.subscriptionId, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAvailableSequenceNumbers = this.getAvailableSequenceNumbers() == null ? -1 : StaticHelper.COUNT(this.getAvailableSequenceNumbers());
        FieldWriterFactory.writeImplicitField((String)"noOfAvailableSequenceNumbers", (Object)noOfAvailableSequenceNumbers, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"availableSequenceNumbers", this.availableSequenceNumbers, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"moreNotifications", (Object)this.moreNotifications, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"notificationMessage", (Object)this.notificationMessage, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfResults = this.getResults() == null ? -1 : StaticHelper.COUNT(this.getResults());
        FieldWriterFactory.writeImplicitField((String)"noOfResults", (Object)noOfResults, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"results", this.results, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDiagnosticInfos = this.getDiagnosticInfos() == null ? -1 : StaticHelper.COUNT(this.getDiagnosticInfos());
        FieldWriterFactory.writeImplicitField((String)"noOfDiagnosticInfos", (Object)noOfDiagnosticInfos, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"diagnosticInfos", this.diagnosticInfos, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PublishResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        PublishResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.availableSequenceNumbers != null) {
            lengthInBits += 32 * this.availableSequenceNumbers.size();
        }
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += this.notificationMessage.getLengthInBits();
        lengthInBits += 32;
        if (this.results != null) {
            i = 0;
            for (StatusCode statusCode : this.results) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.results.size());
                lengthInBits += statusCode.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.diagnosticInfos != null) {
            i = 0;
            for (DiagnosticInfo diagnosticInfo : this.diagnosticInfos) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.diagnosticInfos.size());
                lengthInBits += diagnosticInfo.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PublishResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long subscriptionId = (Long)FieldReaderFactory.readSimpleField((String)"subscriptionId", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAvailableSequenceNumbers = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAvailableSequenceNumbers", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List availableSequenceNumbers = FieldReaderFactory.readCountArrayField((String)"availableSequenceNumbers", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfAvailableSequenceNumbers, (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean moreNotifications = (Boolean)FieldReaderFactory.readSimpleField((String)"moreNotifications", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NotificationMessage notificationMessage = (NotificationMessage)FieldReaderFactory.readSimpleField((String)"notificationMessage", (DataReader)DataReaderFactory.readComplex(() -> (NotificationMessage)ExtensionObjectDefinition.staticParse(readBuffer, 805), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfResults = (Integer)FieldReaderFactory.readImplicitField((String)"noOfResults", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List results = FieldReaderFactory.readCountArrayField((String)"results", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfResults, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDiagnosticInfos = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDiagnosticInfos", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List diagnosticInfos = FieldReaderFactory.readCountArrayField((String)"diagnosticInfos", (DataReader)DataReaderFactory.readComplex(() -> DiagnosticInfo.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDiagnosticInfos, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PublishResponse", new WithReaderArgs[0]);
        return new PublishResponseBuilderImpl(responseHeader, subscriptionId, availableSequenceNumbers, moreNotifications, notificationMessage, results, diagnosticInfos);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishResponse)) {
            return false;
        }
        PublishResponse that = (PublishResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getSubscriptionId() == that.getSubscriptionId() && this.getAvailableSequenceNumbers() == that.getAvailableSequenceNumbers() && this.getMoreNotifications() == that.getMoreNotifications() && this.getNotificationMessage() == that.getNotificationMessage() && this.getResults() == that.getResults() && this.getDiagnosticInfos() == that.getDiagnosticInfos() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getSubscriptionId(), this.getAvailableSequenceNumbers(), this.getMoreNotifications(), this.getNotificationMessage(), this.getResults(), this.getDiagnosticInfos());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PublishResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final long subscriptionId;
        private final List<Long> availableSequenceNumbers;
        private final boolean moreNotifications;
        private final NotificationMessage notificationMessage;
        private final List<StatusCode> results;
        private final List<DiagnosticInfo> diagnosticInfos;

        public PublishResponseBuilderImpl(ResponseHeader responseHeader, long subscriptionId, List<Long> availableSequenceNumbers, boolean moreNotifications, NotificationMessage notificationMessage, List<StatusCode> results, List<DiagnosticInfo> diagnosticInfos) {
            this.responseHeader = responseHeader;
            this.subscriptionId = subscriptionId;
            this.availableSequenceNumbers = availableSequenceNumbers;
            this.moreNotifications = moreNotifications;
            this.notificationMessage = notificationMessage;
            this.results = results;
            this.diagnosticInfos = diagnosticInfos;
        }

        @Override
        public PublishResponse build() {
            PublishResponse publishResponse = new PublishResponse(this.responseHeader, this.subscriptionId, this.availableSequenceNumbers, this.moreNotifications, this.notificationMessage, this.results, this.diagnosticInfos);
            return publishResponse;
        }
    }
}

