/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetMetaDataType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class PublishedDataSetDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<PascalString> dataSetFolder;
    protected final DataSetMetaDataType dataSetMetaData;
    protected final List<KeyValuePair> extensionFields;
    protected final ExtensionObject dataSetSource;

    @Override
    public Integer getExtensionId() {
        return 15580;
    }

    public PublishedDataSetDataType(PascalString name, List<PascalString> dataSetFolder, DataSetMetaDataType dataSetMetaData, List<KeyValuePair> extensionFields, ExtensionObject dataSetSource) {
        this.name = name;
        this.dataSetFolder = dataSetFolder;
        this.dataSetMetaData = dataSetMetaData;
        this.extensionFields = extensionFields;
        this.dataSetSource = dataSetSource;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<PascalString> getDataSetFolder() {
        return this.dataSetFolder;
    }

    public DataSetMetaDataType getDataSetMetaData() {
        return this.dataSetMetaData;
    }

    public List<KeyValuePair> getExtensionFields() {
        return this.extensionFields;
    }

    public ExtensionObject getDataSetSource() {
        return this.dataSetSource;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("PublishedDataSetDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataSetFolder = this.getDataSetFolder() == null ? -1 : StaticHelper.COUNT(this.getDataSetFolder());
        FieldWriterFactory.writeImplicitField((String)"noOfDataSetFolder", (Object)noOfDataSetFolder, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataSetFolder", this.dataSetFolder, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetMetaData", (Object)this.dataSetMetaData, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfExtensionFields = this.getExtensionFields() == null ? -1 : StaticHelper.COUNT(this.getExtensionFields());
        FieldWriterFactory.writeImplicitField((String)"noOfExtensionFields", (Object)noOfExtensionFields, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"extensionFields", this.extensionFields, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"dataSetSource", (Object)this.dataSetSource, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("PublishedDataSetDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        PublishedDataSetDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.dataSetFolder != null) {
            i = 0;
            for (PascalString pascalString : this.dataSetFolder) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataSetFolder.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += this.dataSetMetaData.getLengthInBits();
        lengthInBits += 32;
        if (this.extensionFields != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.extensionFields) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.extensionFields.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        return lengthInBits += this.dataSetSource.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("PublishedDataSetDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataSetFolder = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataSetFolder", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataSetFolder = FieldReaderFactory.readCountArrayField((String)"dataSetFolder", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfDataSetFolder, (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetMetaDataType dataSetMetaData = (DataSetMetaDataType)FieldReaderFactory.readSimpleField((String)"dataSetMetaData", (DataReader)DataReaderFactory.readComplex(() -> (DataSetMetaDataType)ExtensionObjectDefinition.staticParse(readBuffer, 14525), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfExtensionFields = (Integer)FieldReaderFactory.readImplicitField((String)"noOfExtensionFields", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List extensionFields = FieldReaderFactory.readCountArrayField((String)"extensionFields", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfExtensionFields, (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject dataSetSource = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"dataSetSource", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("PublishedDataSetDataType", new WithReaderArgs[0]);
        return new PublishedDataSetDataTypeBuilderImpl(name, dataSetFolder, dataSetMetaData, extensionFields, dataSetSource);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishedDataSetDataType)) {
            return false;
        }
        PublishedDataSetDataType that = (PublishedDataSetDataType)o;
        return this.getName() == that.getName() && this.getDataSetFolder() == that.getDataSetFolder() && this.getDataSetMetaData() == that.getDataSetMetaData() && this.getExtensionFields() == that.getExtensionFields() && this.getDataSetSource() == that.getDataSetSource() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getDataSetFolder(), this.getDataSetMetaData(), this.getExtensionFields(), this.getDataSetSource());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class PublishedDataSetDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<PascalString> dataSetFolder;
        private final DataSetMetaDataType dataSetMetaData;
        private final List<KeyValuePair> extensionFields;
        private final ExtensionObject dataSetSource;

        public PublishedDataSetDataTypeBuilderImpl(PascalString name, List<PascalString> dataSetFolder, DataSetMetaDataType dataSetMetaData, List<KeyValuePair> extensionFields, ExtensionObject dataSetSource) {
            this.name = name;
            this.dataSetFolder = dataSetFolder;
            this.dataSetMetaData = dataSetMetaData;
            this.extensionFields = extensionFields;
            this.dataSetSource = dataSetSource;
        }

        @Override
        public PublishedDataSetDataType build() {
            PublishedDataSetDataType publishedDataSetDataType = new PublishedDataSetDataType(this.name, this.dataSetFolder, this.dataSetMetaData, this.extensionFields, this.dataSetSource);
            return publishedDataSetDataType;
        }
    }
}

