/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ContentFilter;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeTypeDescription;
import org.apache.plc4x.java.opcua.readwrite.RequestHeader;
import org.apache.plc4x.java.opcua.readwrite.ViewDescription;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class QueryFirstRequest
extends ExtensionObjectDefinition
implements Message {
    protected final RequestHeader requestHeader;
    protected final ViewDescription view;
    protected final List<NodeTypeDescription> nodeTypes;
    protected final ContentFilter filter;
    protected final long maxDataSetsToReturn;
    protected final long maxReferencesToReturn;

    @Override
    public Integer getExtensionId() {
        return 615;
    }

    public QueryFirstRequest(RequestHeader requestHeader, ViewDescription view, List<NodeTypeDescription> nodeTypes, ContentFilter filter, long maxDataSetsToReturn, long maxReferencesToReturn) {
        this.requestHeader = requestHeader;
        this.view = view;
        this.nodeTypes = nodeTypes;
        this.filter = filter;
        this.maxDataSetsToReturn = maxDataSetsToReturn;
        this.maxReferencesToReturn = maxReferencesToReturn;
    }

    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public ViewDescription getView() {
        return this.view;
    }

    public List<NodeTypeDescription> getNodeTypes() {
        return this.nodeTypes;
    }

    public ContentFilter getFilter() {
        return this.filter;
    }

    public long getMaxDataSetsToReturn() {
        return this.maxDataSetsToReturn;
    }

    public long getMaxReferencesToReturn() {
        return this.maxReferencesToReturn;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("QueryFirstRequest", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"requestHeader", (Object)this.requestHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"view", (Object)this.view, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfNodeTypes = this.getNodeTypes() == null ? -1 : StaticHelper.COUNT(this.getNodeTypes());
        FieldWriterFactory.writeImplicitField((String)"noOfNodeTypes", (Object)noOfNodeTypes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"nodeTypes", this.nodeTypes, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"filter", (Object)this.filter, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxDataSetsToReturn", (Object)this.maxDataSetsToReturn, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxReferencesToReturn", (Object)this.maxReferencesToReturn, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("QueryFirstRequest", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        QueryFirstRequest _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.requestHeader.getLengthInBits();
        lengthInBits += this.view.getLengthInBits();
        lengthInBits += 32;
        if (this.nodeTypes != null) {
            int i = 0;
            for (NodeTypeDescription element : this.nodeTypes) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.nodeTypes.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += this.filter.getLengthInBits();
        lengthInBits += 32;
        return lengthInBits += 32;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("QueryFirstRequest", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        RequestHeader requestHeader = (RequestHeader)FieldReaderFactory.readSimpleField((String)"requestHeader", (DataReader)DataReaderFactory.readComplex(() -> (RequestHeader)ExtensionObjectDefinition.staticParse(readBuffer, 391), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ViewDescription view = (ViewDescription)FieldReaderFactory.readSimpleField((String)"view", (DataReader)DataReaderFactory.readComplex(() -> (ViewDescription)ExtensionObjectDefinition.staticParse(readBuffer, 513), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfNodeTypes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfNodeTypes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List nodeTypes = FieldReaderFactory.readCountArrayField((String)"nodeTypes", (DataReader)DataReaderFactory.readComplex(() -> (NodeTypeDescription)ExtensionObjectDefinition.staticParse(readBuffer, 575), (ReadBuffer)readBuffer), (long)noOfNodeTypes, (WithReaderArgs[])new WithReaderArgs[0]);
        ContentFilter filter = (ContentFilter)FieldReaderFactory.readSimpleField((String)"filter", (DataReader)DataReaderFactory.readComplex(() -> (ContentFilter)ExtensionObjectDefinition.staticParse(readBuffer, 588), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxDataSetsToReturn = (Long)FieldReaderFactory.readSimpleField((String)"maxDataSetsToReturn", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxReferencesToReturn = (Long)FieldReaderFactory.readSimpleField((String)"maxReferencesToReturn", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("QueryFirstRequest", new WithReaderArgs[0]);
        return new QueryFirstRequestBuilderImpl(requestHeader, view, nodeTypes, filter, maxDataSetsToReturn, maxReferencesToReturn);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryFirstRequest)) {
            return false;
        }
        QueryFirstRequest that = (QueryFirstRequest)o;
        return this.getRequestHeader() == that.getRequestHeader() && this.getView() == that.getView() && this.getNodeTypes() == that.getNodeTypes() && this.getFilter() == that.getFilter() && this.getMaxDataSetsToReturn() == that.getMaxDataSetsToReturn() && this.getMaxReferencesToReturn() == that.getMaxReferencesToReturn() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRequestHeader(), this.getView(), this.getNodeTypes(), this.getFilter(), this.getMaxDataSetsToReturn(), this.getMaxReferencesToReturn());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class QueryFirstRequestBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final RequestHeader requestHeader;
        private final ViewDescription view;
        private final List<NodeTypeDescription> nodeTypes;
        private final ContentFilter filter;
        private final long maxDataSetsToReturn;
        private final long maxReferencesToReturn;

        public QueryFirstRequestBuilderImpl(RequestHeader requestHeader, ViewDescription view, List<NodeTypeDescription> nodeTypes, ContentFilter filter, long maxDataSetsToReturn, long maxReferencesToReturn) {
            this.requestHeader = requestHeader;
            this.view = view;
            this.nodeTypes = nodeTypes;
            this.filter = filter;
            this.maxDataSetsToReturn = maxDataSetsToReturn;
            this.maxReferencesToReturn = maxReferencesToReturn;
        }

        @Override
        public QueryFirstRequest build() {
            QueryFirstRequest queryFirstRequest = new QueryFirstRequest(this.requestHeader, this.view, this.nodeTypes, this.filter, this.maxDataSetsToReturn, this.maxReferencesToReturn);
            return queryFirstRequest;
        }
    }
}

