/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.opcua.readwrite.QueryDataSet;
import org.apache.plc4x.java.opcua.readwrite.ResponseHeader;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class QueryNextResponse
extends ExtensionObjectDefinition
implements Message {
    protected final ResponseHeader responseHeader;
    protected final List<QueryDataSet> queryDataSets;
    protected final PascalByteString revisedContinuationPoint;

    @Override
    public Integer getExtensionId() {
        return 624;
    }

    public QueryNextResponse(ResponseHeader responseHeader, List<QueryDataSet> queryDataSets, PascalByteString revisedContinuationPoint) {
        this.responseHeader = responseHeader;
        this.queryDataSets = queryDataSets;
        this.revisedContinuationPoint = revisedContinuationPoint;
    }

    public ResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public List<QueryDataSet> getQueryDataSets() {
        return this.queryDataSets;
    }

    public PascalByteString getRevisedContinuationPoint() {
        return this.revisedContinuationPoint;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("QueryNextResponse", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"responseHeader", (Object)this.responseHeader, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfQueryDataSets = this.getQueryDataSets() == null ? -1 : StaticHelper.COUNT(this.getQueryDataSets());
        FieldWriterFactory.writeImplicitField((String)"noOfQueryDataSets", (Object)noOfQueryDataSets, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"queryDataSets", this.queryDataSets, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"revisedContinuationPoint", (Object)this.revisedContinuationPoint, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("QueryNextResponse", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        QueryNextResponse _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.responseHeader.getLengthInBits();
        lengthInBits += 32;
        if (this.queryDataSets != null) {
            int i = 0;
            for (QueryDataSet element : this.queryDataSets) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.queryDataSets.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits += this.revisedContinuationPoint.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("QueryNextResponse", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        ResponseHeader responseHeader = (ResponseHeader)FieldReaderFactory.readSimpleField((String)"responseHeader", (DataReader)DataReaderFactory.readComplex(() -> (ResponseHeader)ExtensionObjectDefinition.staticParse(readBuffer, 394), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfQueryDataSets = (Integer)FieldReaderFactory.readImplicitField((String)"noOfQueryDataSets", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List queryDataSets = FieldReaderFactory.readCountArrayField((String)"queryDataSets", (DataReader)DataReaderFactory.readComplex(() -> (QueryDataSet)ExtensionObjectDefinition.staticParse(readBuffer, 579), (ReadBuffer)readBuffer), (long)noOfQueryDataSets, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalByteString revisedContinuationPoint = (PascalByteString)FieldReaderFactory.readSimpleField((String)"revisedContinuationPoint", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("QueryNextResponse", new WithReaderArgs[0]);
        return new QueryNextResponseBuilderImpl(responseHeader, queryDataSets, revisedContinuationPoint);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof QueryNextResponse)) {
            return false;
        }
        QueryNextResponse that = (QueryNextResponse)o;
        return this.getResponseHeader() == that.getResponseHeader() && this.getQueryDataSets() == that.getQueryDataSets() && this.getRevisedContinuationPoint() == that.getRevisedContinuationPoint() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResponseHeader(), this.getQueryDataSets(), this.getRevisedContinuationPoint());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class QueryNextResponseBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final ResponseHeader responseHeader;
        private final List<QueryDataSet> queryDataSets;
        private final PascalByteString revisedContinuationPoint;

        public QueryNextResponseBuilderImpl(ResponseHeader responseHeader, List<QueryDataSet> queryDataSets, PascalByteString revisedContinuationPoint) {
            this.responseHeader = responseHeader;
            this.queryDataSets = queryDataSets;
            this.revisedContinuationPoint = revisedContinuationPoint;
        }

        @Override
        public QueryNextResponse build() {
            QueryNextResponse queryNextResponse = new QueryNextResponse(this.responseHeader, this.queryDataSets, this.revisedContinuationPoint);
            return queryNextResponse;
        }
    }
}

