/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.AggregateConfiguration;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class ReadProcessedDetails
extends ExtensionObjectDefinition
implements Message {
    protected final long startTime;
    protected final long endTime;
    protected final double processingInterval;
    protected final List<NodeId> aggregateType;
    protected final AggregateConfiguration aggregateConfiguration;

    @Override
    public Integer getExtensionId() {
        return 652;
    }

    public ReadProcessedDetails(long startTime, long endTime, double processingInterval, List<NodeId> aggregateType, AggregateConfiguration aggregateConfiguration) {
        this.startTime = startTime;
        this.endTime = endTime;
        this.processingInterval = processingInterval;
        this.aggregateType = aggregateType;
        this.aggregateConfiguration = aggregateConfiguration;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public double getProcessingInterval() {
        return this.processingInterval;
    }

    public List<NodeId> getAggregateType() {
        return this.aggregateType;
    }

    public AggregateConfiguration getAggregateConfiguration() {
        return this.aggregateConfiguration;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("ReadProcessedDetails", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"startTime", (Object)this.startTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"endTime", (Object)this.endTime, (DataWriter)DataWriterFactory.writeSignedLong((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"processingInterval", (Object)this.processingInterval, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAggregateType = this.getAggregateType() == null ? -1 : StaticHelper.COUNT(this.getAggregateType());
        FieldWriterFactory.writeImplicitField((String)"noOfAggregateType", (Object)noOfAggregateType, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"aggregateType", this.aggregateType, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"aggregateConfiguration", (Object)this.aggregateConfiguration, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("ReadProcessedDetails", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        ReadProcessedDetails _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 64;
        lengthInBits += 64;
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.aggregateType != null) {
            int i = 0;
            for (NodeId element : this.aggregateType) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.aggregateType.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits += this.aggregateConfiguration.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("ReadProcessedDetails", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long startTime = (Long)FieldReaderFactory.readSimpleField((String)"startTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        long endTime = (Long)FieldReaderFactory.readSimpleField((String)"endTime", (DataReader)DataReaderFactory.readSignedLong((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        double processingInterval = (Double)FieldReaderFactory.readSimpleField((String)"processingInterval", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAggregateType = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAggregateType", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List aggregateType = FieldReaderFactory.readCountArrayField((String)"aggregateType", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfAggregateType, (WithReaderArgs[])new WithReaderArgs[0]);
        AggregateConfiguration aggregateConfiguration = (AggregateConfiguration)FieldReaderFactory.readSimpleField((String)"aggregateConfiguration", (DataReader)DataReaderFactory.readComplex(() -> (AggregateConfiguration)ExtensionObjectDefinition.staticParse(readBuffer, 950), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("ReadProcessedDetails", new WithReaderArgs[0]);
        return new ReadProcessedDetailsBuilderImpl(startTime, endTime, processingInterval, aggregateType, aggregateConfiguration);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReadProcessedDetails)) {
            return false;
        }
        ReadProcessedDetails that = (ReadProcessedDetails)o;
        return this.getStartTime() == that.getStartTime() && this.getEndTime() == that.getEndTime() && this.getProcessingInterval() == that.getProcessingInterval() && this.getAggregateType() == that.getAggregateType() && this.getAggregateConfiguration() == that.getAggregateConfiguration() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStartTime(), this.getEndTime(), this.getProcessingInterval(), this.getAggregateType(), this.getAggregateConfiguration());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class ReadProcessedDetailsBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long startTime;
        private final long endTime;
        private final double processingInterval;
        private final List<NodeId> aggregateType;
        private final AggregateConfiguration aggregateConfiguration;

        public ReadProcessedDetailsBuilderImpl(long startTime, long endTime, double processingInterval, List<NodeId> aggregateType, AggregateConfiguration aggregateConfiguration) {
            this.startTime = startTime;
            this.endTime = endTime;
            this.processingInterval = processingInterval;
            this.aggregateType = aggregateType;
            this.aggregateConfiguration = aggregateConfiguration;
        }

        @Override
        public ReadProcessedDetails build() {
            ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(this.startTime, this.endTime, this.processingInterval, this.aggregateType, this.aggregateConfiguration);
            return readProcessedDetails;
        }
    }
}

