/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.opcua.readwrite.RolePermissionType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class SecurityGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<PascalString> securityGroupFolder;
    protected final double keyLifetime;
    protected final PascalString securityPolicyUri;
    protected final long maxFutureKeyCount;
    protected final long maxPastKeyCount;
    protected final PascalString securityGroupId;
    protected final List<RolePermissionType> rolePermissions;
    protected final List<KeyValuePair> groupProperties;

    @Override
    public Integer getExtensionId() {
        return 23603;
    }

    public SecurityGroupDataType(PascalString name, List<PascalString> securityGroupFolder, double keyLifetime, PascalString securityPolicyUri, long maxFutureKeyCount, long maxPastKeyCount, PascalString securityGroupId, List<RolePermissionType> rolePermissions, List<KeyValuePair> groupProperties) {
        this.name = name;
        this.securityGroupFolder = securityGroupFolder;
        this.keyLifetime = keyLifetime;
        this.securityPolicyUri = securityPolicyUri;
        this.maxFutureKeyCount = maxFutureKeyCount;
        this.maxPastKeyCount = maxPastKeyCount;
        this.securityGroupId = securityGroupId;
        this.rolePermissions = rolePermissions;
        this.groupProperties = groupProperties;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<PascalString> getSecurityGroupFolder() {
        return this.securityGroupFolder;
    }

    public double getKeyLifetime() {
        return this.keyLifetime;
    }

    public PascalString getSecurityPolicyUri() {
        return this.securityPolicyUri;
    }

    public long getMaxFutureKeyCount() {
        return this.maxFutureKeyCount;
    }

    public long getMaxPastKeyCount() {
        return this.maxPastKeyCount;
    }

    public PascalString getSecurityGroupId() {
        return this.securityGroupId;
    }

    public List<RolePermissionType> getRolePermissions() {
        return this.rolePermissions;
    }

    public List<KeyValuePair> getGroupProperties() {
        return this.groupProperties;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SecurityGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityGroupFolder = this.getSecurityGroupFolder() == null ? -1 : StaticHelper.COUNT(this.getSecurityGroupFolder());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityGroupFolder", (Object)noOfSecurityGroupFolder, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityGroupFolder", this.securityGroupFolder, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"keyLifetime", (Object)this.keyLifetime, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityPolicyUri", (Object)this.securityPolicyUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxFutureKeyCount", (Object)this.maxFutureKeyCount, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxPastKeyCount", (Object)this.maxPastKeyCount, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityGroupId", (Object)this.securityGroupId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRolePermissions = this.getRolePermissions() == null ? -1 : StaticHelper.COUNT(this.getRolePermissions());
        FieldWriterFactory.writeImplicitField((String)"noOfRolePermissions", (Object)noOfRolePermissions, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"rolePermissions", this.rolePermissions, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfGroupProperties = this.getGroupProperties() == null ? -1 : StaticHelper.COUNT(this.getGroupProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfGroupProperties", (Object)noOfGroupProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"groupProperties", this.groupProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("SecurityGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        SecurityGroupDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.securityGroupFolder != null) {
            i = 0;
            for (PascalString pascalString : this.securityGroupFolder) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityGroupFolder.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += 64;
        lengthInBits += this.securityPolicyUri.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += this.securityGroupId.getLengthInBits();
        lengthInBits += 32;
        if (this.rolePermissions != null) {
            i = 0;
            for (RolePermissionType rolePermissionType : this.rolePermissions) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.rolePermissions.size());
                lengthInBits += rolePermissionType.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.groupProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.groupProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.groupProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("SecurityGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityGroupFolder = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityGroupFolder", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityGroupFolder = FieldReaderFactory.readCountArrayField((String)"securityGroupFolder", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfSecurityGroupFolder, (WithReaderArgs[])new WithReaderArgs[0]);
        double keyLifetime = (Double)FieldReaderFactory.readSimpleField((String)"keyLifetime", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString securityPolicyUri = (PascalString)FieldReaderFactory.readSimpleField((String)"securityPolicyUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxFutureKeyCount = (Long)FieldReaderFactory.readSimpleField((String)"maxFutureKeyCount", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        long maxPastKeyCount = (Long)FieldReaderFactory.readSimpleField((String)"maxPastKeyCount", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString securityGroupId = (PascalString)FieldReaderFactory.readSimpleField((String)"securityGroupId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRolePermissions = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRolePermissions", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List rolePermissions = FieldReaderFactory.readCountArrayField((String)"rolePermissions", (DataReader)DataReaderFactory.readComplex(() -> (RolePermissionType)ExtensionObjectDefinition.staticParse(readBuffer, 98), (ReadBuffer)readBuffer), (long)noOfRolePermissions, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfGroupProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfGroupProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List groupProperties = FieldReaderFactory.readCountArrayField((String)"groupProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfGroupProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("SecurityGroupDataType", new WithReaderArgs[0]);
        return new SecurityGroupDataTypeBuilderImpl(name, securityGroupFolder, keyLifetime, securityPolicyUri, maxFutureKeyCount, maxPastKeyCount, securityGroupId, rolePermissions, groupProperties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityGroupDataType)) {
            return false;
        }
        SecurityGroupDataType that = (SecurityGroupDataType)o;
        return this.getName() == that.getName() && this.getSecurityGroupFolder() == that.getSecurityGroupFolder() && this.getKeyLifetime() == that.getKeyLifetime() && this.getSecurityPolicyUri() == that.getSecurityPolicyUri() && this.getMaxFutureKeyCount() == that.getMaxFutureKeyCount() && this.getMaxPastKeyCount() == that.getMaxPastKeyCount() && this.getSecurityGroupId() == that.getSecurityGroupId() && this.getRolePermissions() == that.getRolePermissions() && this.getGroupProperties() == that.getGroupProperties() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getSecurityGroupFolder(), this.getKeyLifetime(), this.getSecurityPolicyUri(), this.getMaxFutureKeyCount(), this.getMaxPastKeyCount(), this.getSecurityGroupId(), this.getRolePermissions(), this.getGroupProperties());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SecurityGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<PascalString> securityGroupFolder;
        private final double keyLifetime;
        private final PascalString securityPolicyUri;
        private final long maxFutureKeyCount;
        private final long maxPastKeyCount;
        private final PascalString securityGroupId;
        private final List<RolePermissionType> rolePermissions;
        private final List<KeyValuePair> groupProperties;

        public SecurityGroupDataTypeBuilderImpl(PascalString name, List<PascalString> securityGroupFolder, double keyLifetime, PascalString securityPolicyUri, long maxFutureKeyCount, long maxPastKeyCount, PascalString securityGroupId, List<RolePermissionType> rolePermissions, List<KeyValuePair> groupProperties) {
            this.name = name;
            this.securityGroupFolder = securityGroupFolder;
            this.keyLifetime = keyLifetime;
            this.securityPolicyUri = securityPolicyUri;
            this.maxFutureKeyCount = maxFutureKeyCount;
            this.maxPastKeyCount = maxPastKeyCount;
            this.securityGroupId = securityGroupId;
            this.rolePermissions = rolePermissions;
            this.groupProperties = groupProperties;
        }

        @Override
        public SecurityGroupDataType build() {
            SecurityGroupDataType securityGroupDataType = new SecurityGroupDataType(this.name, this.securityGroupFolder, this.keyLifetime, this.securityPolicyUri, this.maxFutureKeyCount, this.maxPastKeyCount, this.securityGroupId, this.rolePermissions, this.groupProperties);
            return securityGroupDataType;
        }
    }
}

