/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class SecuritySettingsDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final List<KeyValuePair> recordProperties;
    protected final List<MessageSecurityMode> securityModes;
    protected final List<PascalString> securityPolicyUris;
    protected final PascalString certificateGroupName;

    @Override
    public Integer getExtensionId() {
        return 15561;
    }

    public SecuritySettingsDataType(PascalString name, List<KeyValuePair> recordProperties, List<MessageSecurityMode> securityModes, List<PascalString> securityPolicyUris, PascalString certificateGroupName) {
        this.name = name;
        this.recordProperties = recordProperties;
        this.securityModes = securityModes;
        this.securityPolicyUris = securityPolicyUris;
        this.certificateGroupName = certificateGroupName;
    }

    public PascalString getName() {
        return this.name;
    }

    public List<KeyValuePair> getRecordProperties() {
        return this.recordProperties;
    }

    public List<MessageSecurityMode> getSecurityModes() {
        return this.securityModes;
    }

    public List<PascalString> getSecurityPolicyUris() {
        return this.securityPolicyUris;
    }

    public PascalString getCertificateGroupName() {
        return this.certificateGroupName;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("SecuritySettingsDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfRecordProperties = this.getRecordProperties() == null ? -1 : StaticHelper.COUNT(this.getRecordProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfRecordProperties", (Object)noOfRecordProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"recordProperties", this.recordProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityModes = this.getSecurityModes() == null ? -1 : StaticHelper.COUNT(this.getSecurityModes());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityModes", (Object)noOfSecurityModes, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"securityModes", this.securityModes, (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityPolicyUris = this.getSecurityPolicyUris() == null ? -1 : StaticHelper.COUNT(this.getSecurityPolicyUris());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityPolicyUris", (Object)noOfSecurityPolicyUris, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityPolicyUris", this.securityPolicyUris, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"certificateGroupName", (Object)this.certificateGroupName, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("SecuritySettingsDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        SecuritySettingsDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 32;
        if (this.recordProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.recordProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.recordProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.securityModes != null) {
            lengthInBits += 32 * this.securityModes.size();
        }
        lengthInBits += 32;
        if (this.securityPolicyUris != null) {
            i = 0;
            for (PascalString pascalString : this.securityPolicyUris) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityPolicyUris.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        return lengthInBits += this.certificateGroupName.getLengthInBits();
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("SecuritySettingsDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfRecordProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfRecordProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List recordProperties = FieldReaderFactory.readCountArrayField((String)"recordProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfRecordProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityModes = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityModes", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityModes = FieldReaderFactory.readCountArrayField((String)"securityModes", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (long)noOfSecurityModes, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityPolicyUris = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityPolicyUris", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityPolicyUris = FieldReaderFactory.readCountArrayField((String)"securityPolicyUris", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfSecurityPolicyUris, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString certificateGroupName = (PascalString)FieldReaderFactory.readSimpleField((String)"certificateGroupName", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("SecuritySettingsDataType", new WithReaderArgs[0]);
        return new SecuritySettingsDataTypeBuilderImpl(name, recordProperties, securityModes, securityPolicyUris, certificateGroupName);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecuritySettingsDataType)) {
            return false;
        }
        SecuritySettingsDataType that = (SecuritySettingsDataType)o;
        return this.getName() == that.getName() && this.getRecordProperties() == that.getRecordProperties() && this.getSecurityModes() == that.getSecurityModes() && this.getSecurityPolicyUris() == that.getSecurityPolicyUris() && this.getCertificateGroupName() == that.getCertificateGroupName() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getName(), this.getRecordProperties(), this.getSecurityModes(), this.getSecurityPolicyUris(), this.getCertificateGroupName());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class SecuritySettingsDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final List<KeyValuePair> recordProperties;
        private final List<MessageSecurityMode> securityModes;
        private final List<PascalString> securityPolicyUris;
        private final PascalString certificateGroupName;

        public SecuritySettingsDataTypeBuilderImpl(PascalString name, List<KeyValuePair> recordProperties, List<MessageSecurityMode> securityModes, List<PascalString> securityPolicyUris, PascalString certificateGroupName) {
            this.name = name;
            this.recordProperties = recordProperties;
            this.securityModes = securityModes;
            this.securityPolicyUris = securityPolicyUris;
            this.certificateGroupName = certificateGroupName;
        }

        @Override
        public SecuritySettingsDataType build() {
            SecuritySettingsDataType securitySettingsDataType = new SecuritySettingsDataType(this.name, this.recordProperties, this.securityModes, this.securityPolicyUris, this.certificateGroupName);
            return securitySettingsDataType;
        }
    }
}

