/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.NodeId;
import org.apache.plc4x.java.opcua.readwrite.StructureField;
import org.apache.plc4x.java.opcua.readwrite.StructureType;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class StructureDefinition
extends ExtensionObjectDefinition
implements Message {
    protected final NodeId defaultEncodingId;
    protected final NodeId baseDataType;
    protected final StructureType structureType;
    protected final List<StructureField> fields;

    @Override
    public Integer getExtensionId() {
        return 101;
    }

    public StructureDefinition(NodeId defaultEncodingId, NodeId baseDataType, StructureType structureType, List<StructureField> fields) {
        this.defaultEncodingId = defaultEncodingId;
        this.baseDataType = baseDataType;
        this.structureType = structureType;
        this.fields = fields;
    }

    public NodeId getDefaultEncodingId() {
        return this.defaultEncodingId;
    }

    public NodeId getBaseDataType() {
        return this.baseDataType;
    }

    public StructureType getStructureType() {
        return this.structureType;
    }

    public List<StructureField> getFields() {
        return this.fields;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("StructureDefinition", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"defaultEncodingId", (Object)this.defaultEncodingId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"baseDataType", (Object)this.baseDataType, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"structureType", (String)"StructureType", (Object)((Object)this.structureType), (DataWriter)DataWriterFactory.writeEnum(StructureType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfFields = this.getFields() == null ? -1 : StaticHelper.COUNT(this.getFields());
        FieldWriterFactory.writeImplicitField((String)"noOfFields", (Object)noOfFields, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"fields", this.fields, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("StructureDefinition", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        StructureDefinition _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.defaultEncodingId.getLengthInBits();
        lengthInBits += this.baseDataType.getLengthInBits();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.fields != null) {
            int i = 0;
            for (StructureField element : this.fields) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.fields.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("StructureDefinition", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        NodeId defaultEncodingId = (NodeId)FieldReaderFactory.readSimpleField((String)"defaultEncodingId", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        NodeId baseDataType = (NodeId)FieldReaderFactory.readSimpleField((String)"baseDataType", (DataReader)DataReaderFactory.readComplex(() -> NodeId.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        StructureType structureType = (StructureType)((Object)FieldReaderFactory.readEnumField((String)"structureType", (String)"StructureType", (DataReader)DataReaderFactory.readEnum(StructureType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        int noOfFields = (Integer)FieldReaderFactory.readImplicitField((String)"noOfFields", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List fields = FieldReaderFactory.readCountArrayField((String)"fields", (DataReader)DataReaderFactory.readComplex(() -> (StructureField)ExtensionObjectDefinition.staticParse(readBuffer, 103), (ReadBuffer)readBuffer), (long)noOfFields, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("StructureDefinition", new WithReaderArgs[0]);
        return new StructureDefinitionBuilderImpl(defaultEncodingId, baseDataType, structureType, fields);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition that = (StructureDefinition)o;
        return this.getDefaultEncodingId() == that.getDefaultEncodingId() && this.getBaseDataType() == that.getBaseDataType() && this.getStructureType() == that.getStructureType() && this.getFields() == that.getFields() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getDefaultEncodingId(), this.getBaseDataType(), this.getStructureType(), this.getFields()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class StructureDefinitionBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final NodeId defaultEncodingId;
        private final NodeId baseDataType;
        private final StructureType structureType;
        private final List<StructureField> fields;

        public StructureDefinitionBuilderImpl(NodeId defaultEncodingId, NodeId baseDataType, StructureType structureType, List<StructureField> fields) {
            this.defaultEncodingId = defaultEncodingId;
            this.baseDataType = baseDataType;
            this.structureType = structureType;
            this.fields = fields;
        }

        @Override
        public StructureDefinition build() {
            StructureDefinition structureDefinition = new StructureDefinition(this.defaultEncodingId, this.baseDataType, this.structureType, this.fields);
            return structureDefinition;
        }
    }
}

