/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.StatusCode;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TransferResult
extends ExtensionObjectDefinition
implements Message {
    protected final StatusCode statusCode;
    protected final List<Long> availableSequenceNumbers;

    @Override
    public Integer getExtensionId() {
        return 838;
    }

    public TransferResult(StatusCode statusCode, List<Long> availableSequenceNumbers) {
        this.statusCode = statusCode;
        this.availableSequenceNumbers = availableSequenceNumbers;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public List<Long> getAvailableSequenceNumbers() {
        return this.availableSequenceNumbers;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TransferResult", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"statusCode", (Object)this.statusCode, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfAvailableSequenceNumbers = this.getAvailableSequenceNumbers() == null ? -1 : StaticHelper.COUNT(this.getAvailableSequenceNumbers());
        FieldWriterFactory.writeImplicitField((String)"noOfAvailableSequenceNumbers", (Object)noOfAvailableSequenceNumbers, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"availableSequenceNumbers", this.availableSequenceNumbers, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TransferResult", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        TransferResult _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.statusCode.getLengthInBits();
        lengthInBits += 32;
        if (this.availableSequenceNumbers != null) {
            lengthInBits += 32 * this.availableSequenceNumbers.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("TransferResult", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        StatusCode statusCode = (StatusCode)FieldReaderFactory.readSimpleField((String)"statusCode", (DataReader)DataReaderFactory.readComplex(() -> StatusCode.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfAvailableSequenceNumbers = (Integer)FieldReaderFactory.readImplicitField((String)"noOfAvailableSequenceNumbers", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List availableSequenceNumbers = FieldReaderFactory.readCountArrayField((String)"availableSequenceNumbers", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (long)noOfAvailableSequenceNumbers, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TransferResult", new WithReaderArgs[0]);
        return new TransferResultBuilderImpl(statusCode, availableSequenceNumbers);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransferResult)) {
            return false;
        }
        TransferResult that = (TransferResult)o;
        return this.getStatusCode() == that.getStatusCode() && this.getAvailableSequenceNumbers() == that.getAvailableSequenceNumbers() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getStatusCode(), this.getAvailableSequenceNumbers());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TransferResultBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final StatusCode statusCode;
        private final List<Long> availableSequenceNumbers;

        public TransferResultBuilderImpl(StatusCode statusCode, List<Long> availableSequenceNumbers) {
            this.statusCode = statusCode;
            this.availableSequenceNumbers = availableSequenceNumbers;
        }

        @Override
        public TransferResult build() {
            TransferResult transferResult = new TransferResult(this.statusCode, this.availableSequenceNumbers);
            return transferResult;
        }
    }
}

