/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.PascalByteString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class TrustListDataType
extends ExtensionObjectDefinition
implements Message {
    protected final long specifiedLists;
    protected final List<PascalByteString> trustedCertificates;
    protected final List<PascalByteString> trustedCrls;
    protected final List<PascalByteString> issuerCertificates;
    protected final List<PascalByteString> issuerCrls;

    @Override
    public Integer getExtensionId() {
        return 12556;
    }

    public TrustListDataType(long specifiedLists, List<PascalByteString> trustedCertificates, List<PascalByteString> trustedCrls, List<PascalByteString> issuerCertificates, List<PascalByteString> issuerCrls) {
        this.specifiedLists = specifiedLists;
        this.trustedCertificates = trustedCertificates;
        this.trustedCrls = trustedCrls;
        this.issuerCertificates = issuerCertificates;
        this.issuerCrls = issuerCrls;
    }

    public long getSpecifiedLists() {
        return this.specifiedLists;
    }

    public List<PascalByteString> getTrustedCertificates() {
        return this.trustedCertificates;
    }

    public List<PascalByteString> getTrustedCrls() {
        return this.trustedCrls;
    }

    public List<PascalByteString> getIssuerCertificates() {
        return this.issuerCertificates;
    }

    public List<PascalByteString> getIssuerCrls() {
        return this.issuerCrls;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("TrustListDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"specifiedLists", (Object)this.specifiedLists, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfTrustedCertificates = this.getTrustedCertificates() == null ? -1 : StaticHelper.COUNT(this.getTrustedCertificates());
        FieldWriterFactory.writeImplicitField((String)"noOfTrustedCertificates", (Object)noOfTrustedCertificates, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"trustedCertificates", this.trustedCertificates, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfTrustedCrls = this.getTrustedCrls() == null ? -1 : StaticHelper.COUNT(this.getTrustedCrls());
        FieldWriterFactory.writeImplicitField((String)"noOfTrustedCrls", (Object)noOfTrustedCrls, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"trustedCrls", this.trustedCrls, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfIssuerCertificates = this.getIssuerCertificates() == null ? -1 : StaticHelper.COUNT(this.getIssuerCertificates());
        FieldWriterFactory.writeImplicitField((String)"noOfIssuerCertificates", (Object)noOfIssuerCertificates, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"issuerCertificates", this.issuerCertificates, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfIssuerCrls = this.getIssuerCrls() == null ? -1 : StaticHelper.COUNT(this.getIssuerCrls());
        FieldWriterFactory.writeImplicitField((String)"noOfIssuerCrls", (Object)noOfIssuerCrls, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"issuerCrls", this.issuerCrls, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("TrustListDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        TrustListDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.trustedCertificates != null) {
            i = 0;
            for (PascalByteString element : this.trustedCertificates) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.trustedCertificates.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.trustedCrls != null) {
            i = 0;
            for (PascalByteString element : this.trustedCrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.trustedCrls.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.issuerCertificates != null) {
            i = 0;
            for (PascalByteString element : this.issuerCertificates) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.issuerCertificates.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        lengthInBits += 32;
        if (this.issuerCrls != null) {
            i = 0;
            for (PascalByteString element : this.issuerCrls) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.issuerCrls.size());
                lengthInBits += element.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("TrustListDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long specifiedLists = (Long)FieldReaderFactory.readSimpleField((String)"specifiedLists", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfTrustedCertificates = (Integer)FieldReaderFactory.readImplicitField((String)"noOfTrustedCertificates", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List trustedCertificates = FieldReaderFactory.readCountArrayField((String)"trustedCertificates", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfTrustedCertificates, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfTrustedCrls = (Integer)FieldReaderFactory.readImplicitField((String)"noOfTrustedCrls", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List trustedCrls = FieldReaderFactory.readCountArrayField((String)"trustedCrls", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfTrustedCrls, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfIssuerCertificates = (Integer)FieldReaderFactory.readImplicitField((String)"noOfIssuerCertificates", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List issuerCertificates = FieldReaderFactory.readCountArrayField((String)"issuerCertificates", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfIssuerCertificates, (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfIssuerCrls = (Integer)FieldReaderFactory.readImplicitField((String)"noOfIssuerCrls", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List issuerCrls = FieldReaderFactory.readCountArrayField((String)"issuerCrls", (DataReader)DataReaderFactory.readComplex(() -> PascalByteString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfIssuerCrls, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("TrustListDataType", new WithReaderArgs[0]);
        return new TrustListDataTypeBuilderImpl(specifiedLists, trustedCertificates, trustedCrls, issuerCertificates, issuerCrls);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TrustListDataType)) {
            return false;
        }
        TrustListDataType that = (TrustListDataType)o;
        return this.getSpecifiedLists() == that.getSpecifiedLists() && this.getTrustedCertificates() == that.getTrustedCertificates() && this.getTrustedCrls() == that.getTrustedCrls() && this.getIssuerCertificates() == that.getIssuerCertificates() && this.getIssuerCrls() == that.getIssuerCrls() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSpecifiedLists(), this.getTrustedCertificates(), this.getTrustedCrls(), this.getIssuerCertificates(), this.getIssuerCrls());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class TrustListDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long specifiedLists;
        private final List<PascalByteString> trustedCertificates;
        private final List<PascalByteString> trustedCrls;
        private final List<PascalByteString> issuerCertificates;
        private final List<PascalByteString> issuerCrls;

        public TrustListDataTypeBuilderImpl(long specifiedLists, List<PascalByteString> trustedCertificates, List<PascalByteString> trustedCrls, List<PascalByteString> issuerCertificates, List<PascalByteString> issuerCrls) {
            this.specifiedLists = specifiedLists;
            this.trustedCertificates = trustedCertificates;
            this.trustedCrls = trustedCrls;
            this.issuerCertificates = issuerCertificates;
            this.issuerCrls = issuerCrls;
        }

        @Override
        public TrustListDataType build() {
            TrustListDataType trustListDataType = new TrustListDataType(this.specifiedLists, this.trustedCertificates, this.trustedCrls, this.issuerCertificates, this.issuerCrls);
            return trustListDataType;
        }
    }
}

