/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetOrderingType;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.UadpNetworkMessageContentMask;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class UadpWriterGroupMessageDataType
extends ExtensionObjectDefinition
implements Message {
    protected final long groupVersion;
    protected final DataSetOrderingType dataSetOrdering;
    protected final UadpNetworkMessageContentMask networkMessageContentMask;
    protected final double samplingOffset;
    protected final List<Double> publishingOffset;

    @Override
    public Integer getExtensionId() {
        return 15647;
    }

    public UadpWriterGroupMessageDataType(long groupVersion, DataSetOrderingType dataSetOrdering, UadpNetworkMessageContentMask networkMessageContentMask, double samplingOffset, List<Double> publishingOffset) {
        this.groupVersion = groupVersion;
        this.dataSetOrdering = dataSetOrdering;
        this.networkMessageContentMask = networkMessageContentMask;
        this.samplingOffset = samplingOffset;
        this.publishingOffset = publishingOffset;
    }

    public long getGroupVersion() {
        return this.groupVersion;
    }

    public DataSetOrderingType getDataSetOrdering() {
        return this.dataSetOrdering;
    }

    public UadpNetworkMessageContentMask getNetworkMessageContentMask() {
        return this.networkMessageContentMask;
    }

    public double getSamplingOffset() {
        return this.samplingOffset;
    }

    public List<Double> getPublishingOffset() {
        return this.publishingOffset;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("UadpWriterGroupMessageDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"groupVersion", (Object)this.groupVersion, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"dataSetOrdering", (String)"DataSetOrderingType", (Object)((Object)this.dataSetOrdering), (DataWriter)DataWriterFactory.writeEnum(DataSetOrderingType::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"networkMessageContentMask", (String)"UadpNetworkMessageContentMask", (Object)((Object)this.networkMessageContentMask), (DataWriter)DataWriterFactory.writeEnum(UadpNetworkMessageContentMask::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"samplingOffset", (Object)this.samplingOffset, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfPublishingOffset = this.getPublishingOffset() == null ? -1 : StaticHelper.COUNT(this.getPublishingOffset());
        FieldWriterFactory.writeImplicitField((String)"noOfPublishingOffset", (Object)noOfPublishingOffset, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"publishingOffset", this.publishingOffset, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("UadpWriterGroupMessageDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        UadpWriterGroupMessageDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 32;
        lengthInBits += 64;
        lengthInBits += 32;
        if (this.publishingOffset != null) {
            lengthInBits += 64 * this.publishingOffset.size();
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("UadpWriterGroupMessageDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        long groupVersion = (Long)FieldReaderFactory.readSimpleField((String)"groupVersion", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        DataSetOrderingType dataSetOrdering = (DataSetOrderingType)((Object)FieldReaderFactory.readEnumField((String)"dataSetOrdering", (String)"DataSetOrderingType", (DataReader)DataReaderFactory.readEnum(DataSetOrderingType::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        UadpNetworkMessageContentMask networkMessageContentMask = (UadpNetworkMessageContentMask)((Object)FieldReaderFactory.readEnumField((String)"networkMessageContentMask", (String)"UadpNetworkMessageContentMask", (DataReader)DataReaderFactory.readEnum(UadpNetworkMessageContentMask::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        double samplingOffset = (Double)FieldReaderFactory.readSimpleField((String)"samplingOffset", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfPublishingOffset = (Integer)FieldReaderFactory.readImplicitField((String)"noOfPublishingOffset", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List publishingOffset = FieldReaderFactory.readCountArrayField((String)"publishingOffset", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (long)noOfPublishingOffset, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("UadpWriterGroupMessageDataType", new WithReaderArgs[0]);
        return new UadpWriterGroupMessageDataTypeBuilderImpl(groupVersion, dataSetOrdering, networkMessageContentMask, samplingOffset, publishingOffset);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UadpWriterGroupMessageDataType)) {
            return false;
        }
        UadpWriterGroupMessageDataType that = (UadpWriterGroupMessageDataType)o;
        return this.getGroupVersion() == that.getGroupVersion() && this.getDataSetOrdering() == that.getDataSetOrdering() && this.getNetworkMessageContentMask() == that.getNetworkMessageContentMask() && this.getSamplingOffset() == that.getSamplingOffset() && this.getPublishingOffset() == that.getPublishingOffset() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getGroupVersion(), this.getDataSetOrdering(), this.getNetworkMessageContentMask(), this.getSamplingOffset(), this.getPublishingOffset()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class UadpWriterGroupMessageDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final long groupVersion;
        private final DataSetOrderingType dataSetOrdering;
        private final UadpNetworkMessageContentMask networkMessageContentMask;
        private final double samplingOffset;
        private final List<Double> publishingOffset;

        public UadpWriterGroupMessageDataTypeBuilderImpl(long groupVersion, DataSetOrderingType dataSetOrdering, UadpNetworkMessageContentMask networkMessageContentMask, double samplingOffset, List<Double> publishingOffset) {
            this.groupVersion = groupVersion;
            this.dataSetOrdering = dataSetOrdering;
            this.networkMessageContentMask = networkMessageContentMask;
            this.samplingOffset = samplingOffset;
            this.publishingOffset = publishingOffset;
        }

        @Override
        public UadpWriterGroupMessageDataType build() {
            UadpWriterGroupMessageDataType uadpWriterGroupMessageDataType = new UadpWriterGroupMessageDataType(this.groupVersion, this.dataSetOrdering, this.networkMessageContentMask, this.samplingOffset, this.publishingOffset);
            return uadpWriterGroupMessageDataType;
        }
    }
}

