/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.Variant;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class VariantInt16
extends Variant
implements Message {
    protected final Integer arrayLength;
    protected final List<Short> value;

    @Override
    public Byte getVariantType() {
        return (byte)4;
    }

    public VariantInt16(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions, Integer arrayLength, List<Short> value) {
        super(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions);
        this.arrayLength = arrayLength;
        this.value = value;
    }

    public Integer getArrayLength() {
        return this.arrayLength;
    }

    public List<Short> getValue() {
        return this.value;
    }

    @Override
    protected void serializeVariantChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("VariantInt16", new WithWriterArgs[0]);
        FieldWriterFactory.writeOptionalField((String)"arrayLength", (Object)this.arrayLength, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleTypeArrayField((String)"value", this.value, (DataWriter)DataWriterFactory.writeSignedShort((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("VariantInt16", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int lengthInBits = super.getLengthInBits();
        VariantInt16 _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        if (this.arrayLength != null) {
            lengthInBits += 32;
        }
        if (this.value != null) {
            lengthInBits += 16 * this.value.size();
        }
        return lengthInBits;
    }

    public static Variant.VariantBuilder staticParseVariantBuilder(ReadBuffer readBuffer, Boolean arrayLengthSpecified) throws ParseException {
        readBuffer.pullContext("VariantInt16", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        Integer arrayLength = (Integer)FieldReaderFactory.readOptionalField((String)"arrayLength", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (boolean)arrayLengthSpecified, (WithReaderArgs[])new WithReaderArgs[0]);
        List value = FieldReaderFactory.readCountArrayField((String)"value", (DataReader)DataReaderFactory.readSignedShort((ReadBuffer)readBuffer, (int)16), (long)(arrayLength == null ? 1 : arrayLength), (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("VariantInt16", new WithReaderArgs[0]);
        return new VariantInt16BuilderImpl(arrayLength, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariantInt16)) {
            return false;
        }
        VariantInt16 that = (VariantInt16)o;
        return this.getArrayLength() == that.getArrayLength() && this.getValue() == that.getValue() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArrayLength(), this.getValue());
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class VariantInt16BuilderImpl
    implements Variant.VariantBuilder {
        private final Integer arrayLength;
        private final List<Short> value;

        public VariantInt16BuilderImpl(Integer arrayLength, List<Short> value) {
            this.arrayLength = arrayLength;
            this.value = value;
        }

        @Override
        public VariantInt16 build(boolean arrayLengthSpecified, boolean arrayDimensionsSpecified, Integer noOfArrayDimensions, List<Boolean> arrayDimensions) {
            VariantInt16 variantInt16 = new VariantInt16(arrayLengthSpecified, arrayDimensionsSpecified, noOfArrayDimensions, arrayDimensions, this.arrayLength, this.value);
            return variantInt16;
        }
    }
}

