/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.List;
import java.util.Objects;
import org.apache.plc4x.java.opcua.readwrite.DataSetWriterDataType;
import org.apache.plc4x.java.opcua.readwrite.EndpointDescription;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObject;
import org.apache.plc4x.java.opcua.readwrite.ExtensionObjectDefinition;
import org.apache.plc4x.java.opcua.readwrite.KeyValuePair;
import org.apache.plc4x.java.opcua.readwrite.MessageSecurityMode;
import org.apache.plc4x.java.opcua.readwrite.PascalString;
import org.apache.plc4x.java.spi.codegen.ThreadLocalHelper;
import org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory;
import org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory;
import org.apache.plc4x.java.spi.codegen.io.DataReader;
import org.apache.plc4x.java.spi.codegen.io.DataReaderFactory;
import org.apache.plc4x.java.spi.codegen.io.DataWriter;
import org.apache.plc4x.java.spi.codegen.io.DataWriterFactory;
import org.apache.plc4x.java.spi.generation.Message;
import org.apache.plc4x.java.spi.generation.ParseException;
import org.apache.plc4x.java.spi.generation.ReadBuffer;
import org.apache.plc4x.java.spi.generation.SerializationException;
import org.apache.plc4x.java.spi.generation.StaticHelper;
import org.apache.plc4x.java.spi.generation.WithReaderArgs;
import org.apache.plc4x.java.spi.generation.WithWriterArgs;
import org.apache.plc4x.java.spi.generation.WriteBuffer;
import org.apache.plc4x.java.spi.generation.WriteBufferBoxBased;
import org.apache.plc4x.java.spi.utils.Serializable;

public class WriterGroupDataType
extends ExtensionObjectDefinition
implements Message {
    protected final PascalString name;
    protected final boolean enabled;
    protected final MessageSecurityMode securityMode;
    protected final PascalString securityGroupId;
    protected final List<EndpointDescription> securityKeyServices;
    protected final long maxNetworkMessageSize;
    protected final List<KeyValuePair> groupProperties;
    protected final int writerGroupId;
    protected final double publishingInterval;
    protected final double keepAliveTime;
    protected final short priority;
    protected final List<PascalString> localeIds;
    protected final PascalString headerLayoutUri;
    protected final ExtensionObject transportSettings;
    protected final ExtensionObject messageSettings;
    protected final List<DataSetWriterDataType> dataSetWriters;

    @Override
    public Integer getExtensionId() {
        return 15482;
    }

    public WriterGroupDataType(PascalString name, boolean enabled, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, long maxNetworkMessageSize, List<KeyValuePair> groupProperties, int writerGroupId, double publishingInterval, double keepAliveTime, short priority, List<PascalString> localeIds, PascalString headerLayoutUri, ExtensionObject transportSettings, ExtensionObject messageSettings, List<DataSetWriterDataType> dataSetWriters) {
        this.name = name;
        this.enabled = enabled;
        this.securityMode = securityMode;
        this.securityGroupId = securityGroupId;
        this.securityKeyServices = securityKeyServices;
        this.maxNetworkMessageSize = maxNetworkMessageSize;
        this.groupProperties = groupProperties;
        this.writerGroupId = writerGroupId;
        this.publishingInterval = publishingInterval;
        this.keepAliveTime = keepAliveTime;
        this.priority = priority;
        this.localeIds = localeIds;
        this.headerLayoutUri = headerLayoutUri;
        this.transportSettings = transportSettings;
        this.messageSettings = messageSettings;
        this.dataSetWriters = dataSetWriters;
    }

    public PascalString getName() {
        return this.name;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public PascalString getSecurityGroupId() {
        return this.securityGroupId;
    }

    public List<EndpointDescription> getSecurityKeyServices() {
        return this.securityKeyServices;
    }

    public long getMaxNetworkMessageSize() {
        return this.maxNetworkMessageSize;
    }

    public List<KeyValuePair> getGroupProperties() {
        return this.groupProperties;
    }

    public int getWriterGroupId() {
        return this.writerGroupId;
    }

    public double getPublishingInterval() {
        return this.publishingInterval;
    }

    public double getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public short getPriority() {
        return this.priority;
    }

    public List<PascalString> getLocaleIds() {
        return this.localeIds;
    }

    public PascalString getHeaderLayoutUri() {
        return this.headerLayoutUri;
    }

    public ExtensionObject getTransportSettings() {
        return this.transportSettings;
    }

    public ExtensionObject getMessageSettings() {
        return this.messageSettings;
    }

    public List<DataSetWriterDataType> getDataSetWriters() {
        return this.dataSetWriters;
    }

    @Override
    protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer) throws SerializationException {
        WriteBuffer positionAware = writeBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        writeBuffer.pushContext("WriterGroupDataType", new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"name", (Object)this.name, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeReservedField((String)"reserved", (Object)0, (DataWriter)DataWriterFactory.writeUnsignedByte((WriteBuffer)writeBuffer, (int)7), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"enabled", (Object)this.enabled, (DataWriter)DataWriterFactory.writeBoolean((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleEnumField((String)"securityMode", (String)"MessageSecurityMode", (Object)((Object)this.securityMode), (DataWriter)DataWriterFactory.writeEnum(MessageSecurityMode::getValue, Enum::name, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32)), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"securityGroupId", (Object)this.securityGroupId, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfSecurityKeyServices = this.getSecurityKeyServices() == null ? -1 : StaticHelper.COUNT(this.getSecurityKeyServices());
        FieldWriterFactory.writeImplicitField((String)"noOfSecurityKeyServices", (Object)noOfSecurityKeyServices, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"securityKeyServices", this.securityKeyServices, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"maxNetworkMessageSize", (Object)this.maxNetworkMessageSize, (DataWriter)DataWriterFactory.writeUnsignedLong((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfGroupProperties = this.getGroupProperties() == null ? -1 : StaticHelper.COUNT(this.getGroupProperties());
        FieldWriterFactory.writeImplicitField((String)"noOfGroupProperties", (Object)noOfGroupProperties, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"groupProperties", this.groupProperties, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"writerGroupId", (Object)this.writerGroupId, (DataWriter)DataWriterFactory.writeUnsignedInt((WriteBuffer)writeBuffer, (int)16), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"publishingInterval", (Object)this.publishingInterval, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"keepAliveTime", (Object)this.keepAliveTime, (DataWriter)DataWriterFactory.writeDouble((WriteBuffer)writeBuffer, (int)64), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"priority", (Object)this.priority, (DataWriter)DataWriterFactory.writeUnsignedShort((WriteBuffer)writeBuffer, (int)8), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfLocaleIds = this.getLocaleIds() == null ? -1 : StaticHelper.COUNT(this.getLocaleIds());
        FieldWriterFactory.writeImplicitField((String)"noOfLocaleIds", (Object)noOfLocaleIds, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"localeIds", this.localeIds, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"headerLayoutUri", (Object)this.headerLayoutUri, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"transportSettings", (Object)this.transportSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeSimpleField((String)"messageSettings", (Object)this.messageSettings, (DataWriter)DataWriterFactory.writeComplex((WriteBuffer)writeBuffer), (WithWriterArgs[])new WithWriterArgs[0]);
        int noOfDataSetWriters = this.getDataSetWriters() == null ? -1 : StaticHelper.COUNT(this.getDataSetWriters());
        FieldWriterFactory.writeImplicitField((String)"noOfDataSetWriters", (Object)noOfDataSetWriters, (DataWriter)DataWriterFactory.writeSignedInt((WriteBuffer)writeBuffer, (int)32), (WithWriterArgs[])new WithWriterArgs[0]);
        FieldWriterFactory.writeComplexTypeArrayField((String)"dataSetWriters", this.dataSetWriters, (WriteBuffer)writeBuffer, (WithWriterArgs[])new WithWriterArgs[0]);
        writeBuffer.popContext("WriterGroupDataType", new WithWriterArgs[0]);
    }

    @Override
    public int getLengthInBytes() {
        return (int)Math.ceil((double)this.getLengthInBits() / 8.0);
    }

    @Override
    public int getLengthInBits() {
        int i;
        int lengthInBits = super.getLengthInBits();
        WriterGroupDataType _value = this;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        lengthInBits += this.name.getLengthInBits();
        lengthInBits += 7;
        ++lengthInBits;
        lengthInBits += 32;
        lengthInBits += this.securityGroupId.getLengthInBits();
        lengthInBits += 32;
        if (this.securityKeyServices != null) {
            i = 0;
            for (EndpointDescription endpointDescription : this.securityKeyServices) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.securityKeyServices.size());
                lengthInBits += endpointDescription.getLengthInBits();
            }
        }
        lengthInBits += 32;
        lengthInBits += 32;
        if (this.groupProperties != null) {
            i = 0;
            for (KeyValuePair keyValuePair : this.groupProperties) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.groupProperties.size());
                lengthInBits += keyValuePair.getLengthInBits();
            }
        }
        lengthInBits += 16;
        lengthInBits += 64;
        lengthInBits += 64;
        lengthInBits += 8;
        lengthInBits += 32;
        if (this.localeIds != null) {
            i = 0;
            for (PascalString pascalString : this.localeIds) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.localeIds.size());
                lengthInBits += pascalString.getLengthInBits();
            }
        }
        lengthInBits += this.headerLayoutUri.getLengthInBits();
        lengthInBits += this.transportSettings.getLengthInBits();
        lengthInBits += this.messageSettings.getLengthInBits();
        lengthInBits += 32;
        if (this.dataSetWriters != null) {
            i = 0;
            for (DataSetWriterDataType dataSetWriterDataType : this.dataSetWriters) {
                ThreadLocalHelper.lastItemThreadLocal.set(++i >= this.dataSetWriters.size());
                lengthInBits += dataSetWriterDataType.getLengthInBits();
            }
        }
        return lengthInBits;
    }

    public static ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(ReadBuffer readBuffer, Integer extensionId) throws ParseException {
        readBuffer.pullContext("WriterGroupDataType", new WithReaderArgs[0]);
        ReadBuffer positionAware = readBuffer;
        boolean _lastItem = (Boolean)ThreadLocalHelper.lastItemThreadLocal.get();
        PascalString name = (PascalString)FieldReaderFactory.readSimpleField((String)"name", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        Byte reservedField0 = (Byte)FieldReaderFactory.readReservedField((String)"reserved", (DataReader)DataReaderFactory.readUnsignedByte((ReadBuffer)readBuffer, (int)7), (Object)0, (WithReaderArgs[])new WithReaderArgs[0]);
        boolean enabled = (Boolean)FieldReaderFactory.readSimpleField((String)"enabled", (DataReader)DataReaderFactory.readBoolean((ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        MessageSecurityMode securityMode = (MessageSecurityMode)((Object)FieldReaderFactory.readEnumField((String)"securityMode", (String)"MessageSecurityMode", (DataReader)DataReaderFactory.readEnum(MessageSecurityMode::enumForValue, (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32)), (WithReaderArgs[])new WithReaderArgs[0]));
        PascalString securityGroupId = (PascalString)FieldReaderFactory.readSimpleField((String)"securityGroupId", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfSecurityKeyServices = (Integer)FieldReaderFactory.readImplicitField((String)"noOfSecurityKeyServices", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List securityKeyServices = FieldReaderFactory.readCountArrayField((String)"securityKeyServices", (DataReader)DataReaderFactory.readComplex(() -> (EndpointDescription)ExtensionObjectDefinition.staticParse(readBuffer, 314), (ReadBuffer)readBuffer), (long)noOfSecurityKeyServices, (WithReaderArgs[])new WithReaderArgs[0]);
        long maxNetworkMessageSize = (Long)FieldReaderFactory.readSimpleField((String)"maxNetworkMessageSize", (DataReader)DataReaderFactory.readUnsignedLong((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfGroupProperties = (Integer)FieldReaderFactory.readImplicitField((String)"noOfGroupProperties", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List groupProperties = FieldReaderFactory.readCountArrayField((String)"groupProperties", (DataReader)DataReaderFactory.readComplex(() -> (KeyValuePair)ExtensionObjectDefinition.staticParse(readBuffer, 14535), (ReadBuffer)readBuffer), (long)noOfGroupProperties, (WithReaderArgs[])new WithReaderArgs[0]);
        int writerGroupId = (Integer)FieldReaderFactory.readSimpleField((String)"writerGroupId", (DataReader)DataReaderFactory.readUnsignedInt((ReadBuffer)readBuffer, (int)16), (WithReaderArgs[])new WithReaderArgs[0]);
        double publishingInterval = (Double)FieldReaderFactory.readSimpleField((String)"publishingInterval", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        double keepAliveTime = (Double)FieldReaderFactory.readSimpleField((String)"keepAliveTime", (DataReader)DataReaderFactory.readDouble((ReadBuffer)readBuffer, (int)64), (WithReaderArgs[])new WithReaderArgs[0]);
        short priority = (Short)FieldReaderFactory.readSimpleField((String)"priority", (DataReader)DataReaderFactory.readUnsignedShort((ReadBuffer)readBuffer, (int)8), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfLocaleIds = (Integer)FieldReaderFactory.readImplicitField((String)"noOfLocaleIds", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List localeIds = FieldReaderFactory.readCountArrayField((String)"localeIds", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (long)noOfLocaleIds, (WithReaderArgs[])new WithReaderArgs[0]);
        PascalString headerLayoutUri = (PascalString)FieldReaderFactory.readSimpleField((String)"headerLayoutUri", (DataReader)DataReaderFactory.readComplex(() -> PascalString.staticParse(readBuffer), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject transportSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"transportSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        ExtensionObject messageSettings = (ExtensionObject)FieldReaderFactory.readSimpleField((String)"messageSettings", (DataReader)DataReaderFactory.readComplex(() -> ExtensionObject.staticParse(readBuffer, true), (ReadBuffer)readBuffer), (WithReaderArgs[])new WithReaderArgs[0]);
        int noOfDataSetWriters = (Integer)FieldReaderFactory.readImplicitField((String)"noOfDataSetWriters", (DataReader)DataReaderFactory.readSignedInt((ReadBuffer)readBuffer, (int)32), (WithReaderArgs[])new WithReaderArgs[0]);
        List dataSetWriters = FieldReaderFactory.readCountArrayField((String)"dataSetWriters", (DataReader)DataReaderFactory.readComplex(() -> (DataSetWriterDataType)ExtensionObjectDefinition.staticParse(readBuffer, 15599), (ReadBuffer)readBuffer), (long)noOfDataSetWriters, (WithReaderArgs[])new WithReaderArgs[0]);
        readBuffer.closeContext("WriterGroupDataType", new WithReaderArgs[0]);
        return new WriterGroupDataTypeBuilderImpl(name, enabled, securityMode, securityGroupId, securityKeyServices, maxNetworkMessageSize, groupProperties, writerGroupId, publishingInterval, keepAliveTime, priority, localeIds, headerLayoutUri, transportSettings, messageSettings, dataSetWriters);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WriterGroupDataType)) {
            return false;
        }
        WriterGroupDataType that = (WriterGroupDataType)o;
        return this.getName() == that.getName() && this.getEnabled() == that.getEnabled() && this.getSecurityMode() == that.getSecurityMode() && this.getSecurityGroupId() == that.getSecurityGroupId() && this.getSecurityKeyServices() == that.getSecurityKeyServices() && this.getMaxNetworkMessageSize() == that.getMaxNetworkMessageSize() && this.getGroupProperties() == that.getGroupProperties() && this.getWriterGroupId() == that.getWriterGroupId() && this.getPublishingInterval() == that.getPublishingInterval() && this.getKeepAliveTime() == that.getKeepAliveTime() && this.getPriority() == that.getPriority() && this.getLocaleIds() == that.getLocaleIds() && this.getHeaderLayoutUri() == that.getHeaderLayoutUri() && this.getTransportSettings() == that.getTransportSettings() && this.getMessageSettings() == that.getMessageSettings() && this.getDataSetWriters() == that.getDataSetWriters() && super.equals(that);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.getName(), this.getEnabled(), this.getSecurityMode(), this.getSecurityGroupId(), this.getSecurityKeyServices(), this.getMaxNetworkMessageSize(), this.getGroupProperties(), this.getWriterGroupId(), this.getPublishingInterval(), this.getKeepAliveTime(), this.getPriority(), this.getLocaleIds(), this.getHeaderLayoutUri(), this.getTransportSettings(), this.getMessageSettings(), this.getDataSetWriters()});
    }

    @Override
    public String toString() {
        WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
        try {
            writeBufferBoxBased.writeSerializable((Serializable)this);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
    }

    public static class WriterGroupDataTypeBuilderImpl
    implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
        private final PascalString name;
        private final boolean enabled;
        private final MessageSecurityMode securityMode;
        private final PascalString securityGroupId;
        private final List<EndpointDescription> securityKeyServices;
        private final long maxNetworkMessageSize;
        private final List<KeyValuePair> groupProperties;
        private final int writerGroupId;
        private final double publishingInterval;
        private final double keepAliveTime;
        private final short priority;
        private final List<PascalString> localeIds;
        private final PascalString headerLayoutUri;
        private final ExtensionObject transportSettings;
        private final ExtensionObject messageSettings;
        private final List<DataSetWriterDataType> dataSetWriters;

        public WriterGroupDataTypeBuilderImpl(PascalString name, boolean enabled, MessageSecurityMode securityMode, PascalString securityGroupId, List<EndpointDescription> securityKeyServices, long maxNetworkMessageSize, List<KeyValuePair> groupProperties, int writerGroupId, double publishingInterval, double keepAliveTime, short priority, List<PascalString> localeIds, PascalString headerLayoutUri, ExtensionObject transportSettings, ExtensionObject messageSettings, List<DataSetWriterDataType> dataSetWriters) {
            this.name = name;
            this.enabled = enabled;
            this.securityMode = securityMode;
            this.securityGroupId = securityGroupId;
            this.securityKeyServices = securityKeyServices;
            this.maxNetworkMessageSize = maxNetworkMessageSize;
            this.groupProperties = groupProperties;
            this.writerGroupId = writerGroupId;
            this.publishingInterval = publishingInterval;
            this.keepAliveTime = keepAliveTime;
            this.priority = priority;
            this.localeIds = localeIds;
            this.headerLayoutUri = headerLayoutUri;
            this.transportSettings = transportSettings;
            this.messageSettings = messageSettings;
            this.dataSetWriters = dataSetWriters;
        }

        @Override
        public WriterGroupDataType build() {
            WriterGroupDataType writerGroupDataType = new WriterGroupDataType(this.name, this.enabled, this.securityMode, this.securityGroupId, this.securityKeyServices, this.maxNetworkMessageSize, this.groupProperties, this.writerGroupId, this.publishingInterval, this.keepAliveTime, this.priority, this.localeIds, this.headerLayoutUri, this.transportSettings, this.messageSettings, this.dataSetWriters);
            return writerGroupDataType;
        }
    }
}

