/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.readwrite.utils;

import java.nio.charset.StandardCharsets;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.opcua.readwrite.ExpandedNodeId;

public class StaticHelper {
    public static int utf8LengthToPascalLength(String stringValue) {
        if (stringValue == null) {
            return -1;
        }
        return stringValue.getBytes(StandardCharsets.UTF_8).length;
    }

    public static int pascalLengthToUtf8Length(int slength) {
        return Math.max(slength, 0);
    }

    public static int extensionId(ExpandedNodeId expandedNodeId) {
        try {
            return Integer.parseInt(expandedNodeId.getNodeId().getIdentifier());
        }
        catch (NumberFormatException e) {
            throw new PlcRuntimeException("Invalid node id, expected number, found " + expandedNodeId.getNodeId().getClass().getName());
        }
    }
}

