/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.opcua.tag;

import org.apache.plc4x.java.opcua.readwrite.StatusCode;

public final class OpcuaQualityStatus {
    private static final long STATUS_MASK = 0xC0000000L;
    private static final long STATUS_GOOD = 0L;
    private static final long STATUS_UNCERTAIN = 0x40000000L;
    private static final long STATUS_BAD = 0x80000000L;
    private final StatusCode statusCode;

    public OpcuaQualityStatus(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public boolean isGood() {
        return (this.statusCode.getStatusCode() & 0xC0000000L) == 0L;
    }

    public boolean isBad() {
        return (this.statusCode.getStatusCode() & 0xC0000000L) == 0x80000000L;
    }

    public boolean isUncertain() {
        return (this.statusCode.getStatusCode() & 0xC0000000L) == 0x40000000L;
    }

    public String toString() {
        if (this.isGood()) {
            return "good";
        }
        if (this.isBad()) {
            return "bad";
        }
        return "uncertain";
    }
}

