/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.transport.udp;

import java.net.InetSocketAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.plc4x.java.api.exceptions.PlcRuntimeException;
import org.apache.plc4x.java.spi.configuration.HasConfiguration;
import org.apache.plc4x.java.spi.configuration.PlcTransportConfiguration;
import org.apache.plc4x.java.spi.connection.ChannelFactory;
import org.apache.plc4x.java.spi.transport.Transport;
import org.apache.plc4x.java.transport.udp.DefaultUdpTransportConfiguration;
import org.apache.plc4x.java.transport.udp.UdpChannelFactory;
import org.apache.plc4x.java.transport.udp.UdpTransportConfiguration;

public class UdpTransport
implements Transport,
HasConfiguration<UdpTransportConfiguration> {
    private static final Pattern TRANSPORT_UDP_PATTERN = Pattern.compile("^((?<ip>[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3})|(?<hostname>[a-zA-Z0-9.\\-]+))(:(?<port>[0-9]{1,5}))?");
    private UdpTransportConfiguration configuration;

    public String getTransportCode() {
        return "udp";
    }

    public String getTransportName() {
        return "UDP Datagram Transport";
    }

    public void setConfiguration(UdpTransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public ChannelFactory createChannelFactory(String transportConfig) {
        int port;
        Matcher matcher = TRANSPORT_UDP_PATTERN.matcher(transportConfig);
        if (!matcher.matches()) {
            throw new PlcRuntimeException("Invalid url for UDP transport");
        }
        String ip = matcher.group("ip");
        String hostname = matcher.group("hostname");
        String portString = matcher.group("port");
        int localPort = -1;
        if (portString != null) {
            port = Integer.parseInt(portString);
        } else if (this.configuration != null && this.configuration.getDefaultPort() != -1) {
            port = this.configuration.getDefaultPort();
        } else {
            throw new PlcRuntimeException("No port defined");
        }
        if (this.configuration != null) {
            localPort = this.configuration.getLocalPort();
        }
        InetSocketAddress remoteAddress = new InetSocketAddress(ip == null ? hostname : ip, port);
        if (localPort != -1) {
            InetSocketAddress localAddress = new InetSocketAddress(localPort);
            return new UdpChannelFactory(localAddress, remoteAddress);
        }
        return new UdpChannelFactory(remoteAddress);
    }

    public Class<? extends PlcTransportConfiguration> getTransportConfigType() {
        return DefaultUdpTransportConfiguration.class;
    }
}

