/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.protocol.ByteBufPair;
import org.apache.pulsar.common.protocol.FrameDecoderUtil;
import org.apache.pulsar.common.util.PulsarSslConfiguration;
import org.apache.pulsar.common.util.PulsarSslFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.common.util.netty.NettyFutureUtil;
import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.shade.io.netty.handler.flush.FlushConsolidationHandler;
import org.apache.pulsar.shade.io.netty.handler.proxy.Socks5ProxyHandler;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PulsarChannelInitializer.class);
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final boolean tlsEnabled;
    private final boolean tlsHostnameVerificationEnabled;
    private final InetSocketAddress socks5ProxyAddress;
    private final String socks5ProxyUsername;
    private final String socks5ProxyPassword;
    private final ClientConfigurationData conf;
    private final Map<String, PulsarSslFactory> pulsarSslFactoryMap;
    private static final long TLS_CERTIFICATE_CACHE_MILLIS = TimeUnit.MINUTES.toMillis(1L);

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier, ScheduledExecutorService scheduledExecutorService) throws Exception {
        this.clientCnxSupplier = clientCnxSupplier;
        this.tlsEnabled = conf.isUseTls();
        this.tlsHostnameVerificationEnabled = conf.isTlsHostnameVerificationEnable();
        this.socks5ProxyAddress = conf.getSocks5ProxyAddress();
        this.socks5ProxyUsername = conf.getSocks5ProxyUsername();
        this.socks5ProxyPassword = conf.getSocks5ProxyPassword();
        this.conf = conf.clone();
        if (this.tlsEnabled) {
            this.pulsarSslFactoryMap = new ConcurrentHashMap<String, PulsarSslFactory>();
            if (scheduledExecutorService != null && conf.getAutoCertRefreshSeconds() > 0) {
                scheduledExecutorService.scheduleWithFixedDelay(() -> this.refreshSslContext(conf), conf.getAutoCertRefreshSeconds(), conf.getAutoCertRefreshSeconds(), TimeUnit.SECONDS);
            }
        } else {
            this.pulsarSslFactoryMap = null;
        }
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        ch.pipeline().addLast("consolidation", (ChannelHandler)new FlushConsolidationHandler(1024, true));
        ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.getEncoder(this.tlsEnabled));
        FrameDecoderUtil.addFrameDecoder(ch.pipeline(), 0x500000);
        ChannelHandler clientCnx = this.clientCnxSupplier.get();
        ch.pipeline().addLast("handler", clientCnx);
    }

    CompletableFuture<Channel> initTls(Channel ch, InetSocketAddress sniHost) {
        Objects.requireNonNull(ch, "A channel is required");
        Objects.requireNonNull(sniHost, "A sniHost is required");
        if (!this.tlsEnabled) {
            throw new IllegalStateException("TLS is not enabled in client configuration");
        }
        CompletableFuture<Channel> initTlsFuture = new CompletableFuture<Channel>();
        ch.eventLoop().execute(() -> {
            try {
                PulsarSslFactory pulsarSslFactory = this.pulsarSslFactoryMap.computeIfAbsent(sniHost.getHostName(), key -> {
                    try {
                        PulsarSslFactory factory = (PulsarSslFactory)Class.forName(this.conf.getSslFactoryPlugin()).getConstructor(new Class[0]).newInstance(new Object[0]);
                        PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(this.conf, (String)key);
                        factory.initialize(sslConfiguration);
                        factory.createInternalSslContext();
                        return factory;
                    }
                    catch (Exception e) {
                        log.error("Unable to initialize and create the ssl context", (Throwable)e);
                        initTlsFuture.completeExceptionally(e);
                        return null;
                    }
                });
                if (pulsarSslFactory == null) {
                    return;
                }
                SslHandler handler = new SslHandler(pulsarSslFactory.createClientSslEngine(ch.alloc(), sniHost.getHostName(), sniHost.getPort()));
                if (this.tlsHostnameVerificationEnabled) {
                    SecurityUtility.configureSSLHandler(handler);
                }
                ch.pipeline().addFirst(TLS_HANDLER, (ChannelHandler)handler);
                initTlsFuture.complete(ch);
            }
            catch (Throwable t) {
                initTlsFuture.completeExceptionally(t);
            }
        });
        return initTlsFuture;
    }

    CompletableFuture<Channel> initSocks5IfConfig(Channel ch) {
        CompletableFuture<Channel> initSocks5Future = new CompletableFuture<Channel>();
        if (this.socks5ProxyAddress != null) {
            ch.eventLoop().execute(() -> {
                try {
                    Socks5ProxyHandler socks5ProxyHandler = new Socks5ProxyHandler(this.socks5ProxyAddress, this.socks5ProxyUsername, this.socks5ProxyPassword);
                    ch.pipeline().addFirst(socks5ProxyHandler.protocol(), (ChannelHandler)socks5ProxyHandler);
                    initSocks5Future.complete(ch);
                }
                catch (Throwable t) {
                    initSocks5Future.completeExceptionally(t);
                }
            });
        } else {
            initSocks5Future.complete(ch);
        }
        return initSocks5Future;
    }

    CompletableFuture<Channel> initializeClientCnx(Channel ch, InetSocketAddress logicalAddress, InetSocketAddress unresolvedPhysicalAddress) {
        return NettyFutureUtil.toCompletableFuture(ch.eventLoop().submit(() -> {
            ClientCnx cnx = (ClientCnx)ch.pipeline().get("handler");
            if (cnx == null) {
                throw new IllegalStateException("Missing ClientCnx. This should not happen.");
            }
            if (!logicalAddress.equals(unresolvedPhysicalAddress)) {
                cnx.setTargetBroker(logicalAddress);
            }
            cnx.setRemoteHostName(unresolvedPhysicalAddress.getHostString());
            return ch;
        }));
    }

    protected PulsarSslConfiguration buildSslConfiguration(ClientConfigurationData config, String host) throws PulsarClientException {
        return PulsarSslConfiguration.builder().tlsProvider(config.getSslProvider()).tlsKeyStoreType(config.getTlsKeyStoreType()).tlsKeyStorePath(config.getTlsKeyStorePath()).tlsKeyStorePassword(config.getTlsKeyStorePassword()).tlsTrustStoreType(config.getTlsTrustStoreType()).tlsTrustStorePath(config.getTlsTrustStorePath()).tlsTrustStorePassword(config.getTlsTrustStorePassword()).tlsCiphers(config.getTlsCiphers()).tlsProtocols(config.getTlsProtocols()).tlsTrustCertsFilePath(config.getTlsTrustCertsFilePath()).tlsCertificateFilePath(config.getTlsCertificateFilePath()).tlsKeyFilePath(config.getTlsKeyFilePath()).allowInsecureConnection(config.isTlsAllowInsecureConnection()).requireTrustedClientCertOnConnect(false).tlsEnabledWithKeystore(config.isUseKeyStoreTls()).tlsCustomParams(config.getSslFactoryPluginParams()).authData(config.getAuthentication().getAuthData(host)).serverMode(false).build();
    }

    protected void refreshSslContext(ClientConfigurationData conf) {
        this.pulsarSslFactoryMap.forEach((key, pulsarSslFactory) -> {
            try {
                try {
                    if (conf.isUseKeyStoreTls()) {
                        pulsarSslFactory.getInternalSslContext();
                    } else {
                        pulsarSslFactory.getInternalNettySslContext();
                    }
                }
                catch (Exception e) {
                    log.error("SSL Context is not initialized", (Throwable)e);
                    PulsarSslConfiguration sslConfiguration = this.buildSslConfiguration(conf, (String)key);
                    pulsarSslFactory.initialize(sslConfiguration);
                }
                pulsarSslFactory.update();
            }
            catch (Exception e) {
                log.error("Failed to refresh SSL context", (Throwable)e);
            }
        });
    }

    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }
}

