/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.io.Serializable;
import java.util.Set;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.shade.io.swagger.annotations.ApiModelProperty;

public class PulsarSslConfiguration
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(name="tlsCiphers", value="TLS ciphers to be used", required=true)
    private Set<String> tlsCiphers;
    @ApiModelProperty(name="tlsProtocols", value="TLS protocols to be used", required=true)
    private Set<String> tlsProtocols;
    @ApiModelProperty(name="allowInsecureConnection", value="Insecure Connections are allowed", required=true)
    private boolean allowInsecureConnection;
    @ApiModelProperty(name="requireTrustedClientCertOnConnect", value="Require trusted client certificate on connect", required=true)
    private boolean requireTrustedClientCertOnConnect;
    @ApiModelProperty(name="authData", value="Authentication Data Provider utilized by the Client for identification")
    private AuthenticationDataProvider authData;
    @ApiModelProperty(name="tlsCustomParams", value="Custom Parameters required by Pulsar SSL factory plugins")
    private String tlsCustomParams;
    @ApiModelProperty(name="tlsProvider", value="TLS Provider to be used")
    private String tlsProvider;
    @ApiModelProperty(name="tlsTrustStoreType", value="TLS Trust Store Type to be used")
    private String tlsTrustStoreType;
    @ApiModelProperty(name="tlsTrustStorePath", value="TLS Trust Store Path")
    private String tlsTrustStorePath;
    @ApiModelProperty(name="tlsTrustStorePassword", value="TLS Trust Store Password")
    private String tlsTrustStorePassword;
    @ApiModelProperty(name="tlsTrustCertsFilePath", value=" TLS Trust certificates file path")
    private String tlsTrustCertsFilePath;
    @ApiModelProperty(name="tlsCertificateFilePath", value="Path for the TLS Certificate file")
    private String tlsCertificateFilePath;
    @ApiModelProperty(name="tlsKeyFilePath", value="Path for TLS Private key file")
    private String tlsKeyFilePath;
    @ApiModelProperty(name="tlsKeyStoreType", value="TLS Key Store Type to be used")
    private String tlsKeyStoreType;
    @ApiModelProperty(name="tlsKeyStorePath", value="TLS Key Store Path")
    private String tlsKeyStorePath;
    @ApiModelProperty(name="tlsKeyStorePassword", value="TLS Key Store Password")
    private String tlsKeyStorePassword;
    @ApiModelProperty(name="isTlsEnabledWithKeystore", value="TLS configuration enabled with key store configs")
    private boolean tlsEnabledWithKeystore;
    @ApiModelProperty(name="isServerMode", value="Is the SSL Configuration for a Server or Client", required=true)
    private boolean serverMode;
    @ApiModelProperty(name="isHttps", value="Is the SSL Configuration for a Http client or Server")
    private boolean isHttps;

    public PulsarSslConfiguration clone() {
        try {
            return (PulsarSslConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone PulsarSslConfiguration", e);
        }
    }

    PulsarSslConfiguration(Set<String> tlsCiphers, Set<String> tlsProtocols, boolean allowInsecureConnection, boolean requireTrustedClientCertOnConnect, AuthenticationDataProvider authData, String tlsCustomParams, String tlsProvider, String tlsTrustStoreType, String tlsTrustStorePath, String tlsTrustStorePassword, String tlsTrustCertsFilePath, String tlsCertificateFilePath, String tlsKeyFilePath, String tlsKeyStoreType, String tlsKeyStorePath, String tlsKeyStorePassword, boolean tlsEnabledWithKeystore, boolean serverMode, boolean isHttps) {
        this.tlsCiphers = tlsCiphers;
        this.tlsProtocols = tlsProtocols;
        this.allowInsecureConnection = allowInsecureConnection;
        this.requireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
        this.authData = authData;
        this.tlsCustomParams = tlsCustomParams;
        this.tlsProvider = tlsProvider;
        this.tlsTrustStoreType = tlsTrustStoreType;
        this.tlsTrustStorePath = tlsTrustStorePath;
        this.tlsTrustStorePassword = tlsTrustStorePassword;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsCertificateFilePath = tlsCertificateFilePath;
        this.tlsKeyFilePath = tlsKeyFilePath;
        this.tlsKeyStoreType = tlsKeyStoreType;
        this.tlsKeyStorePath = tlsKeyStorePath;
        this.tlsKeyStorePassword = tlsKeyStorePassword;
        this.tlsEnabledWithKeystore = tlsEnabledWithKeystore;
        this.serverMode = serverMode;
        this.isHttps = isHttps;
    }

    public static PulsarSslConfigurationBuilder builder() {
        return new PulsarSslConfigurationBuilder();
    }

    public Set<String> getTlsCiphers() {
        return this.tlsCiphers;
    }

    public Set<String> getTlsProtocols() {
        return this.tlsProtocols;
    }

    public boolean isAllowInsecureConnection() {
        return this.allowInsecureConnection;
    }

    public boolean isRequireTrustedClientCertOnConnect() {
        return this.requireTrustedClientCertOnConnect;
    }

    public AuthenticationDataProvider getAuthData() {
        return this.authData;
    }

    public String getTlsCustomParams() {
        return this.tlsCustomParams;
    }

    public String getTlsProvider() {
        return this.tlsProvider;
    }

    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    public String getTlsTrustStorePath() {
        return this.tlsTrustStorePath;
    }

    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    public String getTlsKeyStorePath() {
        return this.tlsKeyStorePath;
    }

    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    public boolean isTlsEnabledWithKeystore() {
        return this.tlsEnabledWithKeystore;
    }

    public boolean isServerMode() {
        return this.serverMode;
    }

    public boolean isHttps() {
        return this.isHttps;
    }

    public String toString() {
        return "PulsarSslConfiguration(tlsCiphers=" + this.getTlsCiphers() + ", tlsProtocols=" + this.getTlsProtocols() + ", allowInsecureConnection=" + this.isAllowInsecureConnection() + ", requireTrustedClientCertOnConnect=" + this.isRequireTrustedClientCertOnConnect() + ", authData=" + this.getAuthData() + ", tlsCustomParams=" + this.getTlsCustomParams() + ", tlsProvider=" + this.getTlsProvider() + ", tlsTrustStoreType=" + this.getTlsTrustStoreType() + ", tlsTrustStorePath=" + this.getTlsTrustStorePath() + ", tlsTrustStorePassword=" + this.getTlsTrustStorePassword() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsCertificateFilePath=" + this.getTlsCertificateFilePath() + ", tlsKeyFilePath=" + this.getTlsKeyFilePath() + ", tlsKeyStoreType=" + this.getTlsKeyStoreType() + ", tlsKeyStorePath=" + this.getTlsKeyStorePath() + ", tlsKeyStorePassword=" + this.getTlsKeyStorePassword() + ", tlsEnabledWithKeystore=" + this.isTlsEnabledWithKeystore() + ", serverMode=" + this.isServerMode() + ", isHttps=" + this.isHttps() + ")";
    }

    public static class PulsarSslConfigurationBuilder {
        private Set<String> tlsCiphers;
        private Set<String> tlsProtocols;
        private boolean allowInsecureConnection;
        private boolean requireTrustedClientCertOnConnect;
        private AuthenticationDataProvider authData;
        private String tlsCustomParams;
        private String tlsProvider;
        private String tlsTrustStoreType;
        private String tlsTrustStorePath;
        private String tlsTrustStorePassword;
        private String tlsTrustCertsFilePath;
        private String tlsCertificateFilePath;
        private String tlsKeyFilePath;
        private String tlsKeyStoreType;
        private String tlsKeyStorePath;
        private String tlsKeyStorePassword;
        private boolean tlsEnabledWithKeystore;
        private boolean serverMode;
        private boolean isHttps;

        PulsarSslConfigurationBuilder() {
        }

        public PulsarSslConfigurationBuilder tlsCiphers(Set<String> tlsCiphers) {
            this.tlsCiphers = tlsCiphers;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsProtocols(Set<String> tlsProtocols) {
            this.tlsProtocols = tlsProtocols;
            return this;
        }

        public PulsarSslConfigurationBuilder allowInsecureConnection(boolean allowInsecureConnection) {
            this.allowInsecureConnection = allowInsecureConnection;
            return this;
        }

        public PulsarSslConfigurationBuilder requireTrustedClientCertOnConnect(boolean requireTrustedClientCertOnConnect) {
            this.requireTrustedClientCertOnConnect = requireTrustedClientCertOnConnect;
            return this;
        }

        public PulsarSslConfigurationBuilder authData(AuthenticationDataProvider authData) {
            this.authData = authData;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsCustomParams(String tlsCustomParams) {
            this.tlsCustomParams = tlsCustomParams;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsProvider(String tlsProvider) {
            this.tlsProvider = tlsProvider;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsTrustStoreType(String tlsTrustStoreType) {
            this.tlsTrustStoreType = tlsTrustStoreType;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsTrustStorePath(String tlsTrustStorePath) {
            this.tlsTrustStorePath = tlsTrustStorePath;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsTrustStorePassword(String tlsTrustStorePassword) {
            this.tlsTrustStorePassword = tlsTrustStorePassword;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
            this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsCertificateFilePath(String tlsCertificateFilePath) {
            this.tlsCertificateFilePath = tlsCertificateFilePath;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsKeyFilePath(String tlsKeyFilePath) {
            this.tlsKeyFilePath = tlsKeyFilePath;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsKeyStoreType(String tlsKeyStoreType) {
            this.tlsKeyStoreType = tlsKeyStoreType;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsKeyStorePath(String tlsKeyStorePath) {
            this.tlsKeyStorePath = tlsKeyStorePath;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsKeyStorePassword(String tlsKeyStorePassword) {
            this.tlsKeyStorePassword = tlsKeyStorePassword;
            return this;
        }

        public PulsarSslConfigurationBuilder tlsEnabledWithKeystore(boolean tlsEnabledWithKeystore) {
            this.tlsEnabledWithKeystore = tlsEnabledWithKeystore;
            return this;
        }

        public PulsarSslConfigurationBuilder serverMode(boolean serverMode) {
            this.serverMode = serverMode;
            return this;
        }

        public PulsarSslConfigurationBuilder isHttps(boolean isHttps) {
            this.isHttps = isHttps;
            return this;
        }

        public PulsarSslConfiguration build() {
            return new PulsarSslConfiguration(this.tlsCiphers, this.tlsProtocols, this.allowInsecureConnection, this.requireTrustedClientCertOnConnect, this.authData, this.tlsCustomParams, this.tlsProvider, this.tlsTrustStoreType, this.tlsTrustStorePath, this.tlsTrustStorePassword, this.tlsTrustCertsFilePath, this.tlsCertificateFilePath, this.tlsKeyFilePath, this.tlsKeyStoreType, this.tlsKeyStorePath, this.tlsKeyStorePassword, this.tlsEnabledWithKeystore, this.serverMode, this.isHttps);
        }

        public String toString() {
            return "PulsarSslConfiguration.PulsarSslConfigurationBuilder(tlsCiphers=" + this.tlsCiphers + ", tlsProtocols=" + this.tlsProtocols + ", allowInsecureConnection=" + this.allowInsecureConnection + ", requireTrustedClientCertOnConnect=" + this.requireTrustedClientCertOnConnect + ", authData=" + this.authData + ", tlsCustomParams=" + this.tlsCustomParams + ", tlsProvider=" + this.tlsProvider + ", tlsTrustStoreType=" + this.tlsTrustStoreType + ", tlsTrustStorePath=" + this.tlsTrustStorePath + ", tlsTrustStorePassword=" + this.tlsTrustStorePassword + ", tlsTrustCertsFilePath=" + this.tlsTrustCertsFilePath + ", tlsCertificateFilePath=" + this.tlsCertificateFilePath + ", tlsKeyFilePath=" + this.tlsKeyFilePath + ", tlsKeyStoreType=" + this.tlsKeyStoreType + ", tlsKeyStorePath=" + this.tlsKeyStorePath + ", tlsKeyStorePassword=" + this.tlsKeyStorePassword + ", tlsEnabledWithKeystore=" + this.tlsEnabledWithKeystore + ", serverMode=" + this.serverMode + ", isHttps=" + this.isHttps + ")";
        }
    }
}

