/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.net.ssl.SSLContext;
import org.apache.qpid.amqp_1_0.client.ConnectionErrorException;
import org.apache.qpid.amqp_1_0.client.ConnectionException;
import org.apache.qpid.amqp_1_0.client.SSLOptions;
import org.apache.qpid.amqp_1_0.jms.Connection;
import org.apache.qpid.amqp_1_0.jms.ConnectionMetaData;
import org.apache.qpid.amqp_1_0.jms.Session;
import org.apache.qpid.amqp_1_0.jms.impl.ConnectionMetaDataImpl;
import org.apache.qpid.amqp_1_0.jms.impl.DecodedDestination;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.QueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryQueueImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TemporaryTopicImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TopicImpl;
import org.apache.qpid.amqp_1_0.transport.Container;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.transport.ConnectionError;
import org.apache.qpid.amqp_1_0.type.transport.Error;

public class ConnectionImpl
implements Connection,
QueueConnection,
TopicConnection {
    private final String _protocol;
    private final SSLContext _sslContext;
    private ConnectionMetaData _connectionMetaData;
    private volatile ExceptionListener _exceptionListener;
    private final List<SessionImpl> _sessions = new ArrayList<SessionImpl>();
    private final Object _lock = new Object();
    private org.apache.qpid.amqp_1_0.client.Connection _conn;
    private boolean _isQueueConnection;
    private boolean _isTopicConnection;
    private final Collection<CloseTask> _closeTasks = new ArrayList<CloseTask>();
    private String _host;
    private int _port;
    private final String _username;
    private final String _password;
    private String _remoteHost;
    private String _clientId;
    private String _queuePrefix;
    private String _topicPrefix;
    private boolean _useBinaryMessageId = Boolean.parseBoolean(System.getProperty("qpid.use_binary_message_id", "true"));
    private Boolean _syncPublish;
    private int _maxSessions;
    private int _maxPrefetch;
    private SSLOptions _sslOptions;
    private volatile State _state = State.UNCONNECTED;

    public ConnectionImpl(String host, int port, String username, String password, String clientId) throws JMSException {
        this(host, port, username, password, clientId, false);
    }

    public ConnectionImpl(String host, int port, String username, String password, String clientId, boolean ssl) throws JMSException {
        this(host, port, username, password, clientId, null, ssl);
    }

    public ConnectionImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl) throws JMSException {
        this(host, port, username, password, clientId, remoteHost, ssl, 0);
    }

    public ConnectionImpl(String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl, int maxSessions) throws JMSException {
        this(ssl ? "amqps" : "amqp", host, port, username, password, clientId, remoteHost, ssl, maxSessions);
    }

    public ConnectionImpl(String protocol, String host, int port, String username, String password, String clientId, String remoteHost, boolean ssl, int maxSessions) throws JMSException {
        this(protocol, host, port, username, password, clientId, remoteHost, ssl ? ConnectionImpl.getDefaultSSLContext() : null, maxSessions);
    }

    private static SSLContext getDefaultSSLContext() throws JMSException {
        try {
            return SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException e) {
            JMSException jmsException = new JMSException(e.getMessage());
            jmsException.setLinkedException((Exception)e);
            jmsException.initCause((Throwable)e);
            throw jmsException;
        }
    }

    public ConnectionImpl(String protocol, String host, int port, String username, String password, String clientId, String remoteHost, SSLContext sslContext, int maxSessions) throws JMSException {
        this._protocol = protocol;
        this._host = host;
        this._port = port;
        this._username = username;
        this._password = password;
        this._clientId = clientId;
        this._remoteHost = remoteHost;
        this._sslContext = sslContext;
        this._maxSessions = maxSessions;
        if (!"".equals(System.getProperty("qpid.sync_publish", ""))) {
            this._syncPublish = Boolean.getBoolean("qpid.sync_publish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect() throws JMSException {
        Object object = this._lock;
        synchronized (object) {
            if (this._state == State.UNCONNECTED) {
                this._state = State.STOPPED;
                Container container = this._clientId == null ? new Container() : new Container(this._clientId);
                try {
                    this._conn = new org.apache.qpid.amqp_1_0.client.Connection(this._protocol, this._host, this._port, this._username, this._password, container, this._remoteHost, this._sslContext, this._sslOptions, this._maxSessions - 1);
                    this._conn.setConnectionErrorTask((Runnable)new ConnectionErrorTask());
                    this._connectionMetaData = new ConnectionMetaDataImpl(1, 0, 0);
                    Error connectionError = this._conn.getConnectionError();
                    if (connectionError != null) {
                        throw new JMSException(connectionError.getDescription(), connectionError.getCondition().toString());
                    }
                    if (this._conn.getEndpoint().requiresSASL() && !this._conn.getEndpoint().isAuthenticated()) {
                        throw new JMSSecurityException("Failed to authenticate user[" + this._username + "].");
                    }
                }
                catch (ConnectionException e) {
                    JMSException jmsEx = new JMSException(e.getMessage());
                    jmsEx.setLinkedException((Exception)((Object)e));
                    jmsEx.initCause((Throwable)e);
                    throw jmsEx;
                }
                finally {
                    if (this._conn == null) {
                        this._state = State.UNCONNECTED;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotConnected(String msg) throws IllegalStateException {
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.UNCONNECTED) {
                throw new IllegalStateException(msg);
            }
        }
    }

    @Override
    public SessionImpl createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Session.AcknowledgeMode ackMode;
        try {
            ackMode = transacted ? Session.AcknowledgeMode.SESSION_TRANSACTED : Session.AcknowledgeMode.values()[acknowledgeMode];
        }
        catch (IndexOutOfBoundsException e) {
            JMSException jmsEx = new JMSException("Unknown acknowledgement mode " + acknowledgeMode);
            jmsEx.setLinkedException((Exception)e);
            jmsEx.initCause((Throwable)e);
            throw jmsEx;
        }
        return this.createSession(ackMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionImpl createSession(Session.AcknowledgeMode acknowledgeMode) throws JMSException {
        boolean started = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._state == State.CLOSED) {
                throw new IllegalStateException("Cannot create a session on a closed connection");
            }
            if (this._state == State.UNCONNECTED) {
                this.connect();
                started = true;
            }
        }
        try {
            SessionImpl session = new SessionImpl(this, acknowledgeMode);
            session.setQueueSession(this._isQueueConnection);
            session.setTopicSession(this._isTopicConnection);
            if (this._maxPrefetch != 0) {
                session.setMaxPrefetch(this._maxPrefetch);
            }
            boolean connectionStarted = false;
            Object object2 = this._lock;
            synchronized (object2) {
                this.checkClosed();
                this._sessions.add(session);
                connectionStarted = this._state == State.STARTED;
            }
            if (connectionStarted) {
                session.start();
            }
            return session;
        }
        catch (JMSException e) {
            Error remoteError;
            if (started && e.getLinkedException() instanceof ConnectionErrorException && (remoteError = ((ConnectionErrorException)((Object)e.getLinkedException())).getRemoteError()).getCondition() == ConnectionError.REDIRECT) {
                String networkHost = (String)remoteError.getInfo().get(Symbol.valueOf((String)"network-host"));
                int port = (Integer)remoteError.getInfo().get(Symbol.valueOf((String)"port"));
                String hostName = (String)remoteError.getInfo().get(Symbol.valueOf((String)"hostname"));
                this.reconnect(networkHost, port, hostName);
                return this.createSession(acknowledgeMode);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(SessionImpl session) {
        Object object = this._lock;
        synchronized (object) {
            this._sessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnect(String networkHost, int port, String hostName) {
        Object object = this._lock;
        synchronized (object) {
            this._state = State.UNCONNECTED;
            this._host = networkHost;
            this._port = port;
            this._remoteHost = hostName;
            this._conn = null;
        }
    }

    public String getClientID() throws JMSException {
        this.checkClosed();
        return this._clientId;
    }

    public void setClientID(String value) throws JMSException {
        this.checkNotConnected("Cannot set client-id to \"" + value + "\"; client-id must be set before the connection is used");
        if (this._clientId != null) {
            throw new IllegalStateException("client-id has already been set");
        }
        this._clientId = value;
    }

    @Override
    public ConnectionMetaData getMetaData() throws JMSException {
        this.checkClosed();
        return this._connectionMetaData;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        this.checkClosed();
        return this._exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        this.checkClosed();
        this._exceptionListener = exceptionListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws JMSException {
        ArrayList<SessionImpl> stoppedSessions = null;
        Object object = this._lock;
        synchronized (object) {
            this.checkClosed();
            this.connect();
            if (this._state == State.STOPPED) {
                this._state = State.STARTED;
                stoppedSessions = new ArrayList<SessionImpl>(this._sessions);
            }
            this._lock.notifyAll();
        }
        if (stoppedSessions != null) {
            for (SessionImpl session : stoppedSessions) {
                session.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws JMSException {
        ArrayList<SessionImpl> startedSessions = null;
        Object object = this._lock;
        synchronized (object) {
            switch (this._state) {
                case STARTED: {
                    startedSessions = new ArrayList<SessionImpl>(this._sessions);
                }
                case UNCONNECTED: {
                    this._state = State.STOPPED;
                    break;
                }
                case CLOSED: {
                    throw new IllegalStateException("Closed");
                }
            }
            this._lock.notifyAll();
        }
        if (startedSessions != null) {
            for (SessionImpl session : startedSessions) {
                session.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addOnCloseTask(CloseTask task) {
        Object object = this._lock;
        synchronized (object) {
            this._closeTasks.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOnCloseTask(CloseTask task) {
        Object object = this._lock;
        synchronized (object) {
            this._closeTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        ArrayList<SessionImpl> sessions = null;
        ArrayList<CloseTask> closeTasks = null;
        boolean closeConnection = false;
        Object object = this._lock;
        synchronized (object) {
            if (this._state != State.CLOSED) {
                this._state = State.CLOSED;
                sessions = new ArrayList<SessionImpl>(this._sessions);
                closeTasks = new ArrayList<CloseTask>(this._closeTasks);
                closeConnection = this._conn != null && this._state != State.UNCONNECTED;
            }
            this._lock.notifyAll();
        }
        ArrayList<JMSException> errors = new ArrayList<JMSException>();
        if (sessions != null) {
            for (SessionImpl session : sessions) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    errors.add(e);
                }
            }
            for (CloseTask task : closeTasks) {
                task.onClose();
            }
            if (closeConnection) {
                try {
                    this._conn.close();
                }
                catch (ConnectionErrorException e) {
                    JMSException jmsException = new JMSException("Error while closing connection: " + e.getMessage());
                    jmsException.setLinkedException((Exception)((Object)e));
                    throw jmsException;
                }
            }
        }
        if (!errors.isEmpty()) {
            JMSException jmsException = new JMSException("Error while closing connection: " + ((JMSException)((Object)errors.get(0))).getMessage());
            jmsException.setLinkedException((Exception)errors.get(0));
            throw jmsException;
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this._state == State.CLOSED) {
            throw new IllegalStateException("Closed");
        }
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        return null;
    }

    public TopicSession createTopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        SessionImpl session = this.createSession(transacted, acknowledgeMode);
        session.setTopicSession(true);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Topic topic, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        return null;
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String s, String s1, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        if (this._isQueueConnection) {
            throw new IllegalStateException("QueueConnection cannot be used to create Pub/Sub based resources.");
        }
        return null;
    }

    public QueueSession createQueueSession(boolean transacted, int acknowledgeMode) throws JMSException {
        this.checkClosed();
        SessionImpl session = this.createSession(transacted, acknowledgeMode);
        session.setQueueSession(true);
        return session;
    }

    public ConnectionConsumer createConnectionConsumer(Queue queue, String s, ServerSessionPool serverSessionPool, int i) throws JMSException {
        this.checkClosed();
        return null;
    }

    protected org.apache.qpid.amqp_1_0.client.Connection getClientConnection() {
        return this._conn;
    }

    public boolean isStarted() {
        return this._state == State.STARTED;
    }

    void setQueueConnection(boolean queueConnection) {
        this._isQueueConnection = queueConnection;
    }

    void setTopicConnection(boolean topicConnection) {
        this._isTopicConnection = topicConnection;
    }

    public String getTopicPrefix() {
        return this._topicPrefix;
    }

    public void setTopicPrefix(String topicPrefix) {
        this._topicPrefix = topicPrefix;
    }

    public String getQueuePrefix() {
        return this._queuePrefix;
    }

    public void setQueuePrefix(String queueprefix) {
        this._queuePrefix = queueprefix;
    }

    DecodedDestination toDecodedDestination(DestinationImpl dest) {
        String address = dest.getAddress();
        Set<String> kind = null;
        Class<?> clazz = dest.getClass();
        if (clazz == QueueImpl.class) {
            kind = MessageImpl.JMS_QUEUE_ATTRIBUTES;
            if (this._queuePrefix != null && !address.startsWith(this._queuePrefix)) {
                address = this._queuePrefix + address;
            }
        } else if (clazz == TopicImpl.class) {
            kind = MessageImpl.JMS_TOPIC_ATTRIBUTES;
            if (this._topicPrefix != null && !address.startsWith(this._topicPrefix)) {
                address = this._topicPrefix + address;
            }
        } else if (clazz == TemporaryQueueImpl.class) {
            kind = MessageImpl.JMS_TEMP_QUEUE_ATTRIBUTES;
        } else if (clazz == TemporaryTopicImpl.class) {
            kind = MessageImpl.JMS_TEMP_TOPIC_ATTRIBUTES;
        }
        return new DecodedDestination(address, kind);
    }

    DecodedDestination toDecodedDestination(String address, Set<String> kind) {
        if ((kind == null || kind.equals(MessageImpl.JMS_QUEUE_ATTRIBUTES)) && this._queuePrefix != null && address.startsWith(this._queuePrefix)) {
            return new DecodedDestination(address.substring(this._queuePrefix.length()), MessageImpl.JMS_QUEUE_ATTRIBUTES);
        }
        if ((kind == null || kind.equals(MessageImpl.JMS_TOPIC_ATTRIBUTES)) && this._topicPrefix != null && address.startsWith(this._topicPrefix)) {
            return new DecodedDestination(address.substring(this._topicPrefix.length()), MessageImpl.JMS_TOPIC_ATTRIBUTES);
        }
        return new DecodedDestination(address, kind);
    }

    void setUseBinaryMessageId(boolean useBinaryMessageId) {
        this._useBinaryMessageId = useBinaryMessageId;
    }

    boolean useBinaryMessageId() {
        return this._useBinaryMessageId;
    }

    void setSyncPublish(Boolean syncPublish) {
        this._syncPublish = syncPublish;
    }

    Boolean syncPublish() {
        return this._syncPublish;
    }

    public void setMaxPrefetch(int maxPrefetch) {
        this._maxPrefetch = maxPrefetch;
    }

    public void setSslOptions(SSLOptions sslOptions) {
        this._sslOptions = sslOptions;
    }

    public SSLOptions getSslOptions() {
        return this._sslOptions;
    }

    private class ConnectionErrorTask
    implements Runnable {
        private ConnectionErrorTask() {
        }

        @Override
        public void run() {
            try {
                Error connectionError;
                ExceptionListener exceptionListener = ConnectionImpl.this.getExceptionListener();
                if (exceptionListener != null && (connectionError = ConnectionImpl.this._conn.getConnectionError()) != null) {
                    exceptionListener.onException(new JMSException(connectionError.getDescription(), connectionError.getCondition().toString()));
                }
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
    }

    static interface CloseTask {
        public void onClose() throws JMSException;
    }

    private static enum State {
        UNCONNECTED,
        STOPPED,
        STARTED,
        CLOSED;

    }
}

