/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.amqp_1_0.client.Message;
import org.apache.qpid.amqp_1_0.jms.impl.AmqpMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.BytesMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MapMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.MessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.ObjectMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.SessionImpl;
import org.apache.qpid.amqp_1_0.jms.impl.StreamMessageImpl;
import org.apache.qpid.amqp_1_0.jms.impl.TextMessageImpl;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Section;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpSequence;
import org.apache.qpid.amqp_1_0.type.messaging.AmqpValue;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Data;
import org.apache.qpid.amqp_1_0.type.messaging.DeliveryAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Footer;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.MessageAnnotations;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;

class MessageFactory {
    private final SessionImpl _session;

    MessageFactory(SessionImpl session) {
        this._session = session;
    }

    public MessageImpl createMessage(DestinationImpl destination, Message msg) {
        MessageImpl message;
        Section section;
        List payload = msg.getPayload();
        Header header = null;
        MessageAnnotations messageAnnotations = null;
        DeliveryAnnotations deliveryAnnotations = null;
        Properties properties = null;
        ApplicationProperties appProperties = null;
        Iterator iter = payload.iterator();
        ArrayList<Section> body = new ArrayList<Section>();
        Section section2 = section = iter.hasNext() ? (Section)iter.next() : null;
        if (section instanceof Header) {
            header = (Header)section;
            Section section3 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof DeliveryAnnotations) {
            deliveryAnnotations = (DeliveryAnnotations)section;
            Section section4 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof MessageAnnotations) {
            messageAnnotations = (MessageAnnotations)section;
            Section section5 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof Properties) {
            properties = (Properties)section;
            Section section6 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        if (section instanceof ApplicationProperties) {
            appProperties = (ApplicationProperties)section;
            Section section7 = section = iter.hasNext() ? (Section)iter.next() : null;
        }
        while (section != null && !(section instanceof Footer)) {
            body.add(section);
            section = iter.hasNext() ? (Section)iter.next() : null;
        }
        Footer footer = (Footer)section;
        if (body.size() == 1) {
            Section bodySection = (Section)body.get(0);
            if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof Map) {
                message = new MapMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, (Map)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof List) {
                message = new StreamMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, (List)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof String) {
                message = new TextMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, (String)((AmqpValue)bodySection).getValue(), footer, this._session);
            } else if (bodySection instanceof AmqpValue && ((AmqpValue)bodySection).getValue() instanceof Binary) {
                Binary value = (Binary)((AmqpValue)bodySection).getValue();
                message = new BytesMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, new Data(value), footer, this._session);
            } else if (bodySection instanceof Data) {
                Symbol contentType;
                Data dataSection = (Data)bodySection;
                Symbol symbol = contentType = properties == null ? null : properties.getContentType();
                if (ObjectMessageImpl.CONTENT_TYPE.equals(contentType)) {
                    message = new ObjectMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, dataSection, footer, this._session);
                } else if (contentType != null) {
                    ContentType contentTypeObj = MessageFactory.parseContentType(contentType.toString());
                    String contentTypeType = contentTypeObj.getType();
                    String contentTypeSubType = contentTypeObj.getSubType();
                    if ("text".equals(contentTypeType) || "application".equals(contentTypeType) && contentTypeSubType != null && ("xml".equals(contentTypeSubType) || "json".equals(contentTypeSubType) || "xml-dtd".equals(contentTypeSubType) || "javascript".equals(contentTypeSubType) || contentTypeSubType.endsWith("+xml") || contentTypeSubType.endsWith("+json"))) {
                        Charset charset = contentTypeObj.getParameterNames().contains("charset") ? Charset.forName(contentTypeObj.getParameter("charset").toUpperCase()) : StandardCharsets.US_ASCII;
                        Binary binary = dataSection.getValue();
                        String data = new String(binary.getArray(), binary.getArrayOffset(), binary.getLength(), charset);
                        message = new TextMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, data, footer, this._session);
                    } else {
                        message = new BytesMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, dataSection, footer, this._session);
                    }
                } else {
                    message = new BytesMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, dataSection, footer, this._session);
                }
            } else {
                message = bodySection instanceof AmqpSequence ? new StreamMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, ((AmqpSequence)bodySection).getValue(), footer, this._session) : new AmqpMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, body, footer, this._session);
            }
        } else {
            message = body.size() == 0 ? new AmqpMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, Collections.singletonList(new AmqpValue(null)), footer, this._session) : new AmqpMessageImpl(header, deliveryAnnotations, messageAnnotations, properties, appProperties, body, footer, this._session);
        }
        message.setReadOnly();
        return message;
    }

    static ContentType parseContentType(String contentType) {
        int subTypeSeparator = contentType.indexOf("/");
        final String type = contentType.substring(0, subTypeSeparator).toLowerCase().trim();
        String subTypePart = contentType.substring(subTypeSeparator + 1).toLowerCase().trim();
        if (subTypePart.contains(";")) {
            subTypePart = subTypePart.substring(0, subTypePart.indexOf(";")).trim();
        }
        if (subTypePart.contains("(")) {
            subTypePart = subTypePart.substring(0, subTypePart.indexOf("(")).trim();
        }
        final String subType = subTypePart;
        final HashMap<String, String> parameters = new HashMap<String, String>();
        if (contentType.substring(subTypeSeparator + 1).contains(";")) {
            MessageFactory.parseContentTypeParameters(contentType.substring(contentType.indexOf(";", subTypeSeparator + 1) + 1), parameters);
        }
        return new ContentType(){

            @Override
            public String getType() {
                return type;
            }

            @Override
            public String getSubType() {
                return subType;
            }

            @Override
            public Set<String> getParameterNames() {
                return Collections.unmodifiableMap(parameters).keySet();
            }

            @Override
            public String getParameter(String name) {
                return (String)parameters.get(name);
            }
        };
    }

    private static void parseContentTypeParameters(String parameterString, Map<String, String> parameters) {
        int equalsIndex = parameterString.indexOf("=");
        if (equalsIndex != -1) {
            String remainder;
            String valuePart;
            String paramName = parameterString.substring(0, equalsIndex).trim();
            String string = valuePart = equalsIndex == parameterString.length() - 1 ? "" : parameterString.substring(equalsIndex + 1).trim();
            if (valuePart.startsWith("\"")) {
                int closeQuoteIndex = valuePart.indexOf("\"", 1);
                if (closeQuoteIndex != -1) {
                    parameters.put(paramName, valuePart.substring(1, closeQuoteIndex));
                    remainder = closeQuoteIndex == valuePart.length() - 1 ? "" : valuePart.substring(closeQuoteIndex + 1);
                } else {
                    remainder = "";
                }
            } else {
                Pattern pattern = Pattern.compile("\\s|;|\\(");
                Matcher matcher = pattern.matcher(valuePart);
                if (matcher.matches()) {
                    parameters.put(paramName, valuePart.substring(0, matcher.start()));
                    remainder = valuePart.substring(matcher.start());
                } else {
                    parameters.put(paramName, valuePart);
                    remainder = "";
                }
            }
            int paramSep = remainder.indexOf(";");
            if (paramSep != -1 && paramSep != remainder.length() - 1) {
                MessageFactory.parseContentTypeParameters(remainder.substring(paramSep + 1), parameters);
            }
        }
    }

    static interface ContentType {
        public String getType();

        public String getSubType();

        public Set<String> getParameterNames();

        public String getParameter(String var1);
    }
}

