/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.jms.impl;

import java.util.UUID;
import java.util.WeakHashMap;
import org.apache.qpid.amqp_1_0.jms.Topic;
import org.apache.qpid.amqp_1_0.jms.impl.DestinationImpl;

public class TopicImpl
extends DestinationImpl
implements Topic {
    private static final WeakHashMap<String, TopicImpl> TOPIC_CACHE = new WeakHashMap();

    public TopicImpl(String address) {
        super(address);
    }

    @Override
    public String getTopicName() {
        return this.getAddress();
    }

    public static synchronized TopicImpl createTopic(String address) {
        TopicImpl topic;
        if (address.endsWith("!!")) {
            address = address.substring(0, address.length() - 2);
            String localTerminusName = UUID.randomUUID().toString();
            topic = new TopicImpl(address);
            topic.setLocalTerminus(localTerminusName);
        } else {
            topic = TOPIC_CACHE.get(address);
            if (topic == null) {
                topic = new TopicImpl(address);
                TOPIC_CACHE.put(address, topic);
            }
        }
        return topic;
    }

    public static TopicImpl valueOf(String address) {
        return address == null ? null : TopicImpl.createTopic(address);
    }
}

