/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.jdbc.bonecp;

import com.jolbox.bonecp.BoneCP;
import com.jolbox.bonecp.BoneCPConfig;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.qpid.server.store.jdbc.ConnectionProvider;

public class BoneCPConnectionProvider
implements ConnectionProvider {
    public static final int DEFAULT_MIN_CONNECTIONS_PER_PARTITION = 5;
    public static final int DEFAULT_MAX_CONNECTIONS_PER_PARTITION = 10;
    public static final int DEFAULT_PARTITION_COUNT = 4;
    private final BoneCP _connectionPool;

    public BoneCPConnectionProvider(String connectionUrl, String username, String password, Map<String, String> providerAttributes) throws SQLException {
        BoneCPConfig config = new BoneCPConfig();
        config.setJdbcUrl(connectionUrl);
        if (username != null) {
            config.setUsername(username);
            config.setPassword(password);
        }
        config.setMinConnectionsPerPartition(this.convertToIntWithDefault("qpid.jdbcstore.bonecp.minConnectionsPerPartition", providerAttributes, 5));
        config.setMaxConnectionsPerPartition(this.convertToIntWithDefault("qpid.jdbcstore.bonecp.maxConnectionsPerPartition", providerAttributes, 10));
        config.setPartitionCount(this.convertToIntWithDefault("qpid.jdbcstore.bonecp.partitionCount", providerAttributes, 4));
        this._connectionPool = new BoneCP(config);
    }

    private int convertToIntWithDefault(String key, Map<String, String> context, int defaultValue) {
        if (context.containsKey(key)) {
            try {
                return Integer.parseInt(context.get(key));
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public Connection getConnection() throws SQLException {
        return this._connectionPool.getConnection();
    }

    public void close() throws SQLException {
        this._connectionPool.shutdown();
    }
}

